/********************************************************************************************

   Filename: MCP9803.h

   Original Author: Steven Kay

   Development Group: Autonomous Systems Group, RAL Space

   Original Creation Date: April 2017

   Description: <Desc>

   Revision History: Version 1.0 - Initial Release

 *********************************************************************************************/

#ifndef MCP9803_H
#define MCP9803_H

#include "mbed.h"

#define SUCCESS                 0
#define FAILURE                 1

#define FAIL_EVEN_VALUE         0xFF
#define FAIL_ODD_VALUE          0x00

#define TEMP_REG_POINT          0x00
#define CONFIG_REG_POINT        0x01
#define TEMP_HYST_POINT         0x02
#define TEMP_LIM_SET_POINT      0x03

#define CONFIG_CMD_LENGTH       2
#define TEMP_DATA_LENGTH        2

#define READ_TEMP_FAIL_VALUE    0x0FF0
#define READ_TEMP_FAIL_ERROR    -2000

#define CELCIUS                 0x01
#define FARENHEIT               0x02
#define KELVIN                  0x03
#define FORMAT_FAIL             -1000

#define RAW_TO_C                0.0625
#define C_F_1                   1.8
#define C_F_2                   32
#define C_TO_F                  273.15


union CONFIG_REG
{
    struct
    {
        unsigned int SHUTDOWN_BIT: 1;
        unsigned int COMP_INT_BIT: 1;
        unsigned int ALERT_POLARITY_BIT: 1;
        unsigned int FAULT_QUEUE: 2;
        unsigned int ADC_RES: 2;
        unsigned int ONE_SHOT: 1;
    } CONFIG_BITS;
    
    uint8_t CONFIG_VALUE;
};

class MCP9803
{
    
public:
    MCP9803(PinName sda, PinName scl, int Address, int frequency);
    int ConfigSensor(   int shutdown, int comp_int, int alert_polarity,
                        int fault_guide, int adc_res, int one_shot);

    
    int RawTempValue();
    float FormattedTempValue(int format);

private:
    I2C *_I2C;
    int chipAddress;
    union CONFIG_REG CONFIG_REG_VALUE; 
    
    char *inBuffer;
    
    int I2C_Write(char *dataOut,int dataLen);
    char *I2C_Read(int dataLen);
    void setBufferSize(int dataLen); 

};

#endif