/********************************************************************************************

   Filename: MC33926.cpp
   
   Original Author: Steven Kay

   Development Group: Steve!!

   Original Creation Date: April 2017

   Description: <Desc>

   Revision History: Version 1.0 - Initial Release

 *********************************************************************************************/
 #include "mbed.h"
 #include "MC33926.h"
 
 
MC33926::MC33926(PinName pinIN1, PinName pinIN2, PinName pinFB, PinName pinSF)
{
//    _pinSF.disable_irq();    
    _pinIN1 = new PwmOut(pinIN1);
    _pinIN2 = new PwmOut(pinIN2);
    _pinFB = new AnalogIn(pinFB);
    _pinSF = new InterruptIn(pinSF);
    
    // Set period to 2ms (frequency 500Hz)
    _pinIN1 -> period_ms(DRIVER_PWM_PERIOD);
    _pinIN2 -> period_ms(DRIVER_PWM_PERIOD);

    // Initialise to 0% Duty Cycle
    SetPWMPulsewidth(RESET,0);
    SetPWMPulsewidth(RESET,0);
        
}



void MC33926::SetPWMPulsewidth(int direction, float PWM_Pulsewidth)
{
    // FORWARD = 1
    if(direction == FORWARD)
    {
        _pinIN1 -> write(PWM_Pulsewidth); 
        _pinIN2 -> write(0); 
    }
    // REVERSE = 0
    else if(direction == REVERSE)
    {
        _pinIN1 -> write(0);
        _pinIN2 -> write(PWM_Pulsewidth);
    }
    // DEFAUULT or RESET != 1 OR 0
    else
    {
        _pinIN1 -> write(0);
        _pinIN2 -> write(0);
    }    
}



float MC33926::ReadCurrentFeedback()
{
    float temp = _pinFB -> read();
    
    // Insert some conversion formats
    float currentValue = temp;
    
    return currentValue;
}



//void MC33926::StatusFlagWatch(bool latchPol)
//{
//    // if == 1, enable IRQ
//    if(latchPol)
//    {
//        _pinSF -> enable_irq();
//        _pinSF -> fall(this,&MC33926::StatusFlagISR);
//    }
//    // if == 0, disable IRQ
//    else
//    {
//        _pinSF -> disable_irq();
//    }
//}
//
//
//void MC33926::ResetStatus()
//{
//    statusFlag = 0;
//}
//
//
//
//bool MC33926::GetStatus()
//{
//    return statusFlag;
//}
//
//
//
//void MC33926::StatusFlagISR()
//{
//    // An Interrupt has been generated
//    statusFlag = 1;
//}