/* #####################################################################
                            Latch_FET_Driver.h
                            ------------------
                
                          Surface Ship, Group 5
                          ---------------------
 
 Written by:        Steven Kay
 
 Date:              February 2016
 
 Function:          This 
 
 Version:           1.0
 
 Version History
 ---------------
 
 1.1                rgdfgdfgdfggdfgdg
 
 1.0                gdgddfdddgd
    
 ##################################################################### */


#include "mbed.h"

#ifndef LATCH_FET_DRIVER
#define LATCH_FET_DRIVER


#define LOW 0
#define HIGH 1

#define STATE_DELAY 10


class Latch_FET_Driver
{

public:
    /*  =============================================================
    Latch_FET_Driver constructor 
    
    Inputs
    ------
    PinName D:      Pin to create D input to D Latch
    PinName CLK:    Pin to create CLK input to D Latch 
    
    Description
    -----------
    
    Once the new DigitalOut types are assigned, the D Latch at
    the given Pins is initialised to an outputLow state, ensuring
    that uopn setup, a known state is entered quickly.
    
    =============================================================  */ 
    Latch_FET_Driver(PinName D,PinName CLK);
    
    /*  =============================================================
    outputHigh public method
    
    Inputs
    ------
    No functionally passed parameters
    The method acts upon the DigitalOut types; _D and _CLK
    
    Description
    -----------
    Procedure to assert a HIGH state onto a D Latch attached to
    PinName D and PinName CLK
    =============================================================  */ 
    void outputHigh();
    
    /*  =============================================================
    outputLow public method
    
    Inputs
    ------
    No functionally passed parameters
    The method acts upon the DigitalOut types; _D and _CLK
    
    Description
    -----------
    Procedure to assert a LOW state onto a D Latch attached to
    PinName D and PinName CLK
    =============================================================  */ 
    void outputLow();
    
private:
    
protected:
    // DigitalOut types used for assignment of PinName data types
    DigitalOut *_D;
    DigitalOut *_CLK;
};

#endif