/* #####################################################################
                        Latch_FET_Driver.cpp
                        --------------------------
                
                          Surface Ship, Group 5
                          ---------------------
 
 Written by:        Steven Kay
 
 Date:              February 2016
 
 Function:          This 
 
 Version:           1.0
 
 Version History
 ---------------
 
 1.1                rgdfgdfgdfggdfgdg
 
 1.0                gdgddfdddgd
    
 ##################################################################### */

#include "mbed.h"
#include "Latch_FET_Driver.h"


/*  =============================================================
    Latch_FET_Driver constructor 
    
    Inputs
    ------
    PinName D:      Pin to create D input to D Latch
    PinName CLK:    Pin to create CLK input to D Latch 
    
    Description
    -----------
    
    Once the new DigitalOut types are assigned, the D Latch at
    the given Pins is initialised to an outputLow state, ensuring
    that uopn setup, a known state is entered quickly.
    
    =============================================================  */ 
Latch_FET_Driver::Latch_FET_Driver(PinName D,PinName CLK)
{
    // Assign passed in Pin Names as new DigitalOut data types
    _D = new DigitalOut(D);
    _CLK = new DigitalOut(CLK);
    
    // Ensure that D latch does not enter unknown state
    // Initialise is the same as the outputLow method
    Latch_FET_Driver::outputLow();
}

/*  ================================================================
    outputHigh is a public method to set a HIGH output on the given
    D Latch.
    
    The procedure to set Q into a HIGH condition is as follows;
        
    1. Ensure CLK is low
    2. Set D high
    3. wait STATE_DELAY us
    4. Set CLK high
    5. wait 10*STATE_DELAY us
    6. Set CLK low
    7. wait STATE_DELAY us
    8. set D low
    9. return void
    ================================================================  */ 
void Latch_FET_Driver::outputHigh()
{
    _CLK -> write(LOW);
    _D -> write(HIGH);
    wait_us(STATE_DELAY);
    _CLK -> write(HIGH); 
    wait_us(10*STATE_DELAY);
    _CLK -> write(LOW);
    wait_us(STATE_DELAY);
    _D -> write(LOW);
}

/*  ================================================================
    outputLow is a public method to set a HIGH output on the given
    D Latch.
    
    The procedure to set Q into a LOW condition is as follows;
        
    1. Ensure CLK is low
    2. Set D low
    3. wait STATE_DELAY us
    4. Set CLK high
    5. wait 10*STATE_DELAY us
    6. Set CLK low
    7. wait STATE_DELAY us
    8. return void
    ================================================================  */ 
void Latch_FET_Driver::outputLow()
{
    _CLK -> write(LOW);
    _D -> write(LOW);
    wait_us(STATE_DELAY);
    _CLK -> write(HIGH); 
    wait_us(10*STATE_DELAY);
    _CLK -> write(LOW);
    wait_us(STATE_DELAY);
}


