/* #####################################################################
                               Tasks.cpp
                               ---------
                
                     Embedded Software - Assignment 2
                     --------------------------------
 
 Written by:        Steven Kay
 
 Date:              February 2016
 
 Function:          This code defines the operations of all of the 
                    methods, or tasks used by the cyclic executive
     
 ##################################################################### */

#include "mbed.h"
#include "Tasks.h"

/* ==================================== Task 1 ==================================== */
Task1::Task1(PinName squareWaveInPin)
{
    // Construct new DigitalIn object using the pin number provided
    _squareWaveIn = new DigitalIn(squareWaveInPin);
}
    
void Task1::MeasureFrequency()
{
    // If pulse is initially low, wait until rising edge before starting timer    
    if(_squareWaveIn -> read() == LOW)
    {
        while(_squareWaveIn -> read() == LOW)
        {
            wait_us(SAMPLE_FREQ);
        }
        
        _Task1Timer.start();
        
        // Once timer has started, wait until falling edge before breaking and
        // stopping timer
        while(_squareWaveIn -> read() == HIGH)
        {
            wait_us(SAMPLE_FREQ);
        }
    }
    
    // If pulse is initially high, wait until falling edge before starting timer
    else if(_squareWaveIn -> read()== HIGH)
    {
        while(_squareWaveIn -> read() == HIGH)
        {
            wait_us(SAMPLE_FREQ);
        }
        
        _Task1Timer.start();
        
        // Once timer has started, wait until rising edge before breaking and
        // stopping timer
        while(_squareWaveIn -> read() == LOW)
        {
            wait_us(SAMPLE_FREQ);
        }
    }
    
    // Stop timer after breaking while loop conditions    
    _Task1Timer.stop();
    
    // Calculate frequency from timer (either high or low time)
    // do this by multiplying the time by 2 (high + low time) and dividing it,
    // converting it to a frequency
    // Store frequency in private class field
    Task1::measuredFrequency = (1000000/(2*_Task1Timer.read_us()));
    
    // Reset timer
    _Task1Timer.reset();
  
}

int Task1::ReadFrequency()
{
    // Run private method to calculate the frequency
    MeasureFrequency();   
    
    // Return private field showing the newest frequency calculation
    return measuredFrequency;
}

/* ==================================== Task 2 ==================================== */
Task2::Task2(PinName digitalInCheckPin)
{
    //Construct new DigitalIn object from provided pin
    _digitalInCheck = new DigitalIn(digitalInCheckPin);
}

bool Task2::digitalInState()
{
    // Check state of pin, returning a TRUE if high, false if LOW
    if(_digitalInCheck -> read())
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}


/* ==================================== Task 3 ==================================== */
Task3::Task3(PinName WatchdogPin)
{
    // Construct new DigitalOut object using provided pin
    _Watchdog = new DigitalOut(WatchdogPin);
}
    
void Task3::OutputWatchdogPulse()
{
    // Produce a 15ms pulse when method called
    _Watchdog -> write(HIGH);
    wait_ms(WATCHDOG_PULSE_WIDTH);
    _Watchdog -> write(LOW);
}


/* ==================================== Task 4 ==================================== */
Task4::Task4(PinName Analog1Pin,PinName Analog2Pin)
{
    // Construct new AnalogIn objects from provided pins
    _AnalogIn1 = new AnalogIn(Analog1Pin);
    _AnalogIn2 = new AnalogIn(Analog2Pin);
}

float *Task4::returnAnalogReadings()
{
    // Declare local scope fields to retain current totals
    float readBuffer_1 = 0.0;
    float readBuffer_2 = 0.0;

    // Read 4 samples from AnalogIn pins
    for(int readCount = 0;readCount < NUM_ANALOG_SAMPLES; readCount++)
    {
        // Add to readBuffer with new weighted reading.
        // 3.3v due to supply voltage
        readBuffer_1 += ((_AnalogIn1 -> read())*V_SUPPLY);
        readBuffer_2 += ((_AnalogIn2 -> read())*V_SUPPLY); 
    }
    
    // Construct local buffer
    float outputBuffer[2];
    
    // Construct elements in outputBuffer array as averaged sample
    outputBuffer[0] = readBuffer_1/NUM_ANALOG_SAMPLES;
    outputBuffer[1] = readBuffer_2/NUM_ANALOG_SAMPLES;
    
    // Construct pointer to return the initial element of the outputBuffer
    float *outputBufferPtr =&outputBuffer[0];
    
    // Return pointer to first element of outputBuffer
    return outputBufferPtr;    
}

/* ==================================== Task 5 ==================================== */
Task5::Task5(PinName sda, PinName scl, int address)
{
    // Declare and initialise the LCD display
    _par_port = new MCP23017(sda,scl,address);
    _lcd = new WattBob_TextLCD(_par_port);
    _par_port -> write_bit(1,BL_BIT);
}

void Task5::updateDisplay(  int task1Param,
                            int task2Param,
                            int errorState,
                            float task4Channel1,
                            float task4Channel2  )
{
    // Print standard expression using input fields
    _lcd -> cls();
    _lcd -> locate(0,0);
    _lcd -> printf("F-%4dHz S1-%d E%d",task1Param,task2Param,errorState);
    _lcd -> locate(1,0);
    _lcd -> printf("C1-%1.2f C2-%1.2f ",task4Channel1,task4Channel2);
}

/* ==================================== Task 6 ==================================== */
int Task6::updateErrorCode(int switch_1, float analog1, float analog2)
{
    // Using input fields, conduct a logical equation7
    // returning CDTN_MET when true, CDTN_FAIL when false
    if(switch_1 == HIGH && (analog1 > analog2))
    {
        return ERROR_CODE_CDTN_MET;
    }
    else
    {
        return ERROR_CODE_CDTN_FAIL;
    }
}

/* ==================================== Task 5 ==================================== */
Task7::Task7(   PinName mosi,
                PinName miso,
                PinName sck,
                PinName cs,
                const char *SDName,
                const char *dir    )
{
    // Construct new SDFileSystem object
    _sd = new SDFileSystem(mosi,miso,sck,cs, SDName);
    
    // Call private method to create default directory
    makeDirectory(dir);
}

void Task7::makeDirectory(const char *dir)
{
    // Create directory onto sd card
    mkdir(dir,0777);
}

int Task7::openFile(const char *dirFile,const char *accessType)
{
    // Create pointer to FILE object
    Task7::fp = fopen(dirFile,accessType);
    
    // If failed to open file, return 1, indicating error, else return 0
    if(Task7::fp == NULL)
    {
        return 1;
    }
    return 0;
}

void Task7::writeData(const char *dataStream)
{
    // Print Stream of data to FILE object fp
    fprintf(Task7::fp,dataStream);
}

void Task7::closeFile()
{
    // Close file located at fp
    fclose(Task7::fp);    
}