#include "mbed.h"
#include "EthernetNetIf.h"
#include "UDPSocket.h"

EthernetNetIf eth;
UDPSocket udp;

int main() {
  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
  // Use the IP of the client.
  Host unicast(IpAddr(192,168,0,2), 21567, NULL);
 
  udp.bind(unicast);
  
  char sampleStr[256];
  
  udp.sendto("hello", 5, &unicast);  // The first packet disappears.
  wait(0.1);
  
 // while(true)
 // {
    Net::poll();
    uint16_t x = 301;
    for (int i = 0; i < 200; i+=2) {
      sampleStr[i + 1] = x & 0xff;
      sampleStr[i] = (x >> 8) & 0xff;
      //printf("s[0] = %d s[1] = %d  ", sampleStr[i], sampleStr[i+1]);
      printf("%d ", x);
      x += 200; 
    }
    udp.sendto(sampleStr, 200, &unicast);
    wait(10);
 // }
}