#include "mbed.h"
#include "HIDScope.h"
#define SERIAL_BAUD 115200  // baud rate for serial communication
 
 Serial pc(USBTX,USBRX);
 
// Define the HIDScope and Ticker object
HIDScope    scope(1);
Ticker      scopeTimer;
 
// Read the analog input
AnalogIn    a0(A0);
// AnalogIn pot(A0);

// Set LED out
DigitalOut  led(LED_RED);
volatile int i = 0;

 
const float kTimeLedToggle = .5f;  // period of blinking
const int   kLedOn=0;             // Led on if 0
volatile float pot = 0.0;
 
// The data read and send function
void scopeSend()
{
    i=i+a0.read();
    
    if (i > 100){
        i=0;
        }
    // pot = a0.read();
    scope.set(0, i);
    scope.send();
    pc.printf("\r\n b \r\n");
    pc.printf("\r\n %f \r\n",i);
}

void SwitchLed(){
    led = not led;
}
 
int main()
{
    pc.baud(SERIAL_BAUD);
    pc.printf("\r\n ***THERMONUCLEAR WARFARE COMMENCES*** \r\n");
    
    led = not kLedOn;
    // Create ticker for LED and attach
    Ticker tick_toggle_led;
    tick_toggle_led.attach(SwitchLed,kTimeLedToggle);
    
    // Attach the data read and send function at 100 Hz
    scopeTimer.attach(&scopeSend, 0.01f);
   
    while(true);
}