#include "HIDScope.h"

HIDScope::HIDScope(int channels, bool non_blocking) : send_non_blocking(non_blocking), hid(64,64)
{
    bufferData      = new float[channels]();
    channelCount    = channels;
    scopeData.length = 64;
}

void HIDScope::set(int ch, float val)
{
    bufferData[ch] = val;
}

void HIDScope::set(int ch, int val)
{
    set(ch,(float)val);
}

void HIDScope::set(int ch, bool val)
{
    set(ch,(val ? 1.0f : 0.0f));
}

void HIDScope::set(int ch, double val)
{
    set(ch,(float)val);
}

void HIDScope::send()
{    
    memcpy(&scopeData.data, bufferData, sizeof( float ) * channelCount); // Copy a 4 byte float to the char array
    hid.sendNB(&scopeData);
}