/* mbed TextLCD Library
 * Copyright (c) 2007-2009 sford
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * TODO: Needs serious rework/neatening up!
 */
 
#include "TextLCD.h"

#include "mbed.h"
#include "error.h"

using namespace mbed;



TextLCD::TextLCD(PinName rs, PinName rw, PinName e, PinName d0, PinName d1, 
    PinName d2, PinName d3, int columns, int rows) : _rw(rw), _rs(rs), 
    _e(e), _d(d0, d1, d2, d3), _columns(columns), _rows(rows) {

//    _rows = 2;
//    _columns = 16;
    // Mon, 27 Apr 2009 23:32:34 +0200
    // Kevin Konradt:
    // When using a LCD with 1 row x 16 characters
    // instead of 2x16, try changing _columns to 8.
    // (display seems to split the 16 characters into 
    // 2 virtual rows with 8 characters each.)

    _rw = 0;
    _e  = 1;
    _rs = 0; // command mode

    // Should theoretically wait 15ms, but most things will be powered up pre-reset
    // so i'll disable that for the minute. If implemented, could wait 15ms post reset
    // instead
    // wait(0.015); 
        
    // send "Display Settings" 3 times (Only top nibble of 0x30 as we've got 4-bit bus)
    for(int i=0; i<3; i++) {
        writeNibble(0x3);
        wait(0.00164);      // this command takes 1.64ms, so wait for it
    }
    writeNibble(0x2); // 4-bit mode
            
    writeCommand(0x28);    // Function set 001 BW N F - -  
    writeCommand(0x0C);
    writeCommand(0x6);  //  Cursor Direction and Display Shift : 0000 01 CD S (CD 0-left, 1-right S(hift) 0-no, 1-yes
    
    cls();
}

int TextLCD::_putc(int value) {
    if(value == '\n') {
        newline();
    } else {
        writeData(value);
    }
    return value;
}

int TextLCD::_getc() {
    return 0;
}

void TextLCD::newline() {
    _column = 0;
    _row++;
    if(_row >= _rows) {
        _row = 0;
    }
    locate(_column, _row); 
}

void TextLCD::locate(int column, int row) {
    if(column < 0 || column >= _columns || row < 0 || row >= _rows) {
        error("locate(%d,%d) out of range on %dx%d display", column, row, _columns, _rows);
        return;
    }

     _row = row; 
     _column = column; 
     int address=0; 
      
     if (_rows > 2) { 
         // row 0 : 0x0->0x13 
         // row 1 : 0x40->0x53 
         // row 2 : 0x14->0x27 
         // row 3 : 0x54->0x67 
          
         switch (_row) { 
             case (0) : address = 0x80 + _column; 
             break; 
             case (1) : address = 0xc0 + _column; 
             break; 
             case (2) : address = 0x94 + _column; 
             break; 
             case (3) : address = 0xd4 + _column; 
             break; 
         }         
              
     } 
     else { 
         // memory starts at 0x80, and is 40 chars long per row 
         address = 0x80 + (_row * 40)  + _column;  
     } 
      
     writeCommand(address);             
 } 

void TextLCD::cls() {
    writeCommand(0x01); // Clear Display
    wait(0.005);        // This command takes 1.64 ms
      locate(0, 0);
}

void TextLCD::reset() {
    cls();
}

void TextLCD::clock() {
    wait(0.005);
    _e = 0;
    wait(0.005);  // most instructions take 40us
    _e = 1;    
}

void TextLCD::writeNibble(int value) {
    _d = value;
    clock();
}

void TextLCD::writeByte(int value) {
    writeNibble(value >> 4);
    writeNibble(value >> 0);
}

void TextLCD::writeCommand(int command) {
    _rs = 0;
    writeByte(command);
}

void TextLCD::writeData(int data) {
    _rs = 1;
    writeByte(data);
    _column++;
    if(_column >= _columns) {
        newline();
    } 
}
