/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "SDFileSystem.h"

Serial pc(SERIAL_TX, SERIAL_RX);
SDFileSystem sd(SPI_MOSI, SPI_MISO, SPI_SCK, D4, "sd"); // MOSI, MISO, SCK, CS

FILE *fp;

int main() 
{
  pc.baud(115200); // console terminal to 115200 baud
  wait(2);
  
  pc.printf("Initializing\r\n");
    
  fp = fopen("/sd/hello.txt", "r");
    
  if (fp != NULL) 
  {
    fclose(fp);
    remove("/sd/hello.txt");
    pc.printf("Remove an existing file with the same name\r\n");
  }
    
  fp = fopen("/sd/hello.txt", "w");
    
  if (fp == NULL) 
  {
    pc.printf("Unable to write the file\r\n");
  } 
  else 
  {
    fprintf(fp, "mbed SDCard application!");
    fclose(fp);
    pc.printf("File successfully written!\r\n");
  }
}
