#include "mbed.h"
#include "WIZnetInterface.h"
#include "SNTPClient.h"

/*
*  WIZnet 5500 Config for nucleo 411
*/
Serial pc(SERIAL_TX, SERIAL_RX);
SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK); // mosi, miso, sclk

#define USE_DHCP    1

const char * IP_Addr    = "192.168.2.72";
const char * IP_Subnet  = "255.255.255.0";
const char * IP_Gateway = "192.168.2.2";
//unsigned char MAC_Addr[6] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
unsigned char MAC_Addr[6] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xDD };

int main() 
{
  pc.baud(115200); // console terminal to 115200 baud

  spi.frequency(1000000);
  WIZnetInterface ethernet(&spi,D10, D3);

  pc.printf("Ethernet Init\r\n");
#if USE_DHCP
  int ret = ethernet.init(MAC_Addr);
#else
  int ret = ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
#endif

  if (!ret) 
  {
    pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
    ret = ethernet.connect();
    
    if (!ret) 
    {
      pc.printf("IP: %s, MASK: %s, GW: %s\r\n", ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
    }
    else
    {
      pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
      exit(0);
    }
  }
  else
  {
    pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
    exit(0);
  }
    
  printf("IP Address is %s\n\r", ethernet.getIPAddress());

  SNTPClient sntp("time.nist.gov", 6);   // timezone: PST
  sntp.connect();

  datetime time;
  
  while (1) 
  {
    if(sntp.getTime(&time) == true) 
    {
      printf("%d-%d-%d, %d:%d:%d\r\n", time.yy, time.mo, time.dd, time.hh, time.mm, time.ss);
    }
    else 
    {
      printf("failed receive..\r\n");
    }
    
    wait(1.0);
  }
}