#include "mbed.h"
#include "WIZnetInterface.h"
#include <stdio.h>
#include <string.h>

#define USE_DHCP    1

const char * IP_Addr    = "192.168.1.2";
const char * IP_Subnet  = "255.255.255.0";
const char * IP_Gateway = "192.168.1.1";
unsigned char MAC_Addr[6] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xD0 };
    
Serial pc(SERIAL_TX, SERIAL_RX);

SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK); // mosi, miso, sclk
    
#define PORT   80

bool serverIsListened = false;
bool clientIsConnected = false;

int main (void)
{
  spi.frequency(1000000);
  WIZnetInterface ethernet(&spi,D10, D3);

  pc.printf("Ethernet Init\r\n");
#if USE_DHCP
  int ret = ethernet.init(MAC_Addr);
#else
  int ret = ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
#endif

  if (!ret) 
  {
    pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
    ret = ethernet.connect();
    
    if (!ret) 
    {
      pc.printf("IP: %s, MASK: %s, GW: %s\r\n", ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
    }
    else
    {
      pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
      exit(0);
    }
  }
  else
  {
    pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
    exit(0);
  }

    // late binding 
    TCPSocketServer svr;
    TCPSocketConnection client;
    
    //setup tcp socket
    if(svr.bind(PORT)< 0) 
    {
        pc.printf("tcp server bind failed.\n\r");
        return -1;
    } 
    else
     {
        pc.printf("tcp server bind successed.\n\r");
        serverIsListened = true;
    }

    if(svr.listen(1) < 0)
     {
        pc.printf("tcp server listen failed.\n\r");
        return -1;
    }
    else
    {
        pc.printf("tcp server is listening...\n\r");
    }

    //listening for http GET request
  while (serverIsListened) 
  {
    //blocking mode(never timeout)
    if(svr.accept(client)<0) 
    {
      pc.printf("failed to accept connection.\n\r");
    }
    else 
    {
      pc.printf("connection success!\n\rIP: %s\n\r",client.get_address());
      clientIsConnected = true;

      while(clientIsConnected) 
      {
        char buffer[1024] = {};
                
        switch(client.receive(buffer, 1023)) 
        {
          case 0:
            pc.printf("recieved buffer is empty.\n\r");
            clientIsConnected = false;
            break;
                        
          case -1:
            pc.printf("failed to read data from client.\n\r");
            clientIsConnected = false;
            break;
                        
          default:
            pc.printf("Recieved Data: %d\n\r\n\r%.*s\n\r",strlen(buffer),strlen(buffer),buffer);
                        
            if(buffer[0] == 'G' && buffer[1] == 'E' && buffer[2] == 'T' ) 
            {
              pc.printf("GET request incomming.\n\r");
              //setup http response header & data
              char echoHeader[256] = {};
              sprintf(echoHeader,"HTTP/1.1 200 OK\n\rContent-Length: %d\n\rContent-Type: text\n\rConnection: Close\n\r\n\r",strlen(buffer));
              client.send(echoHeader,strlen(echoHeader));
              client.send(buffer,strlen(buffer));
              clientIsConnected = false;
              pc.printf("echo back done.\n\r");
            }
            
            break;
        }
      }
            
      pc.printf("close connection.\n\rtcp server is listening...\n\r");
            
      client.close();
    }
  }
}
