#include "mbed.h"
#include "M2XStreamClient.h"
#include "WIZnetInterface.h"
#include "TCPSocketConnection.h"
#include "x_cube_mems.h"

#define RPINT_DEBUG_INFO 1

#if RPINT_DEBUG_INFO
#define DEBUG pc.printf
#else
#define DEBUG(...)
#endif

#define USE_DHCP    1

Serial pc(SERIAL_TX, SERIAL_RX);
SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK); // mosi, miso, sclk
WIZnetInterface ethernet(&spi,D10, D3);/*  WIZnet 5500 Config for nucleo 411 */

/* Fill these field in from you ATT M2X Account */
char streamName_T[] = "temperature"; // Stream you want to push to
char streamName_H[] = "humidity";    // Stream you want to push to
char streamName_P[] = "pressure";    // Stream you want to push to

char m2xKey[] = "cf5454902aad1b81f4bf55743fbc0ccc"; // Your M2X API Key or Master API Key
char deviceId[] = "1e166d399d3996f3b9da939b6b78dab9"; // Device you want to push to
/* to access the data go to: https://m2x.att.com/catalog/1e166d399d3996f3b9da939b6b78dab9 */

Client client;
M2XStreamClient m2xClient(&client, m2xKey,1,"52.22.150.98");/* Initialize the M2X client: api-m2x.att.com */

volatile float TEMPERATURE_Value_C;
volatile float HUMIDITY_Value;
volatile float PRESSURE_Value;

/* location: https://www.google.com/maps/@47.6752865,-122.1444922,13.5z */
double latitude = 47.6752865;
double longitude = -122.1444922; // You can also read those values from a GPS
double elevation = 13.5;

X_CUBE_MEMS *mems_expansion_board = X_CUBE_MEMS::Instance(); /* Create sensor board object */

Ticker update_task_ticker;

void ethernet_init(void);
void update_task(void);

int main()
{
  ethernet_init();

  int ret = m2xClient.updateLocation(deviceId, streamName_T, latitude, longitude, elevation);

  update_task_ticker.attach(&update_task, 5.0);
  
  while (true) 
  {
  }
}

void update_task()
{
    int ret;
    
    mems_expansion_board->hts221.GetTemperature((float *)&TEMPERATURE_Value_C);/* Read temperature */
    mems_expansion_board->hts221.GetHumidity   ((float *)&HUMIDITY_Value);
    mems_expansion_board->lps25h.GetPressure   ((float *)&PRESSURE_Value);
    
    ret = m2xClient.updateStreamValue(deviceId, streamName_T, TEMPERATURE_Value_C);/* Send to M2X */
    ret = m2xClient.updateStreamValue(deviceId, streamName_P, PRESSURE_Value);/* Send to M2X */
    ret = m2xClient.updateStreamValue(deviceId, streamName_H, HUMIDITY_Value);/* Send to M2X */
        
    DEBUG("Temperature:\t\t %f C\r\n", TEMPERATURE_Value_C);
    DEBUG("Humidity:\t\t %f%%\r\n", HUMIDITY_Value);
    DEBUG("Pressure:\t\t %f hPa\r\n", PRESSURE_Value);
    DEBUG("send() returned %d\r\n", ret);
}

void ethernet_init()
{
#if (USE_DHCP == 0)
const char * IP_Addr    = "192.168.1.2";
const char * IP_Subnet  = "255.255.255.0";
const char * IP_Gateway = "192.168.1.1";
#endif

unsigned char MAC_Addr[6] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
//unsigned char MAC_Addr[6] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xDE };

  spi.frequency(1000000);

  DEBUG("Ethernet Init\r\n");
#if USE_DHCP
  int ret = ethernet.init(MAC_Addr);
#else
  int ret = ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
#endif

  if (!ret) 
  {
    DEBUG("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
    ret = ethernet.connect();
    
    if (!ret) 
    {
      DEBUG("IP: %s, MASK: %s, GW: %s\r\n", ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
    }
    else
    {
      DEBUG("Error ethernet.connect() - ret = %d\r\n", ret);
      exit(0);
    }
  }
  else
  {
    DEBUG("Error ethernet.init() - ret = %d\r\n", ret);
    exit(0);
  }
}
