#include "mbed.h"
#include "M2XStreamClient.h"
#include "WIZnetInterface.h"
#include "TCPSocketConnection.h"


/*
*  WIZnet 5500 Config for nucleo 411
*/
Serial pc(SERIAL_TX, SERIAL_RX);
SPI spi(D11, D12, D13); // mosi, miso, sclk

#define USE_DHCP    1

const char * IP_Addr    = "192.168.2.72";
const char * IP_Subnet  = "255.255.255.0";
const char * IP_Gateway = "192.168.2.2";
unsigned char MAC_Addr[6] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
//
// Fill these field in from you ATT M2X Account
//
char deviceId[] = "<deviceID>"; // Device you want to push to
char streamName[] = "<streamID>"; // Stream you want to push to
char m2xKey[] = "<deviceAPIKey>"; // Your M2X API Key or Master API Key

int main()
{
  pc.baud(115200); // console terminal to 115200 baud

  pc.printf("STM32 WIZnet M2X Example\r\n");

  pc.printf("Initializing SPI\r\n");
  spi.frequency(1000000);
  pc.printf("Initializing Ethernet\r\n");
  WIZnetInterface ethernet(&spi,D10, D3);

#if USE_DHCP
  pc.printf("Ethernet Init\r\n");
  int ret = ethernet.init(MAC_Addr);
#else
  int ret = ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
#endif

  if (!ret) 
  {
    pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
    ret = ethernet.connect();
    
    if (!ret) 
    {
      pc.printf("IP: %s, MASK: %s, GW: %s\r\n",
      ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
    }
    else
    {
      pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
      exit(0);
    }
  }
  else
  {
    pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
    exit(0);
  }

    // Initialize the M2X client
    Client client;
    M2XStreamClient m2xClient(&client, m2xKey,1,"52.22.150.98"); // api-m2x.att.com
    
    volatile int randomNumber = 0;

    while (true) {
        // send a random number to M2X every 5 seconds
        randomNumber = rand();
        ret = m2xClient.updateStreamValue(deviceId, streamName, randomNumber);
        printf("send() returned %d\r\n", ret);
        wait(5.0);
    }
}