#include "mbed.h"

InterruptIn up(p20);
InterruptIn dn(p19);
InterruptIn sel(p18);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

/* Prototypes */
void button_up();
void button_down();
void button_select();

int main() {

    /* Change the pullup mode of the buttons. */
    up.mode(PullUp);
    dn.mode(PullUp);
    sel.mode(PullUp);

    /* Init the LEDs */
    led1 = 0;
    led2 = 1;
    led3 = 0;
    led4 = 1;
    
    /* Set the functions to call when a button is pushed. */
    //up.fall(&button_up);
    //dn.fall(&button_down);
    sel.fall(&button_select);

    while (1) {
        wait(2);
        led1 = !led1;
        led2 = !led2;
        led3 = !led3;
        led4 = !led4;
    }
}

void button_up() {
    led1 = !led1;
    wait(1);
}

void button_down() {
    led2 = !led2;
    wait(1);
}

void button_select() {    
    led3 = !led3;
    wait(1);
}



