/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Revision 1.0.
@author Saleh Jaffal
@date   April 2015
*/

#ifndef MAIN_H
#define MAIN_H
//#include "beep.h"
#include "mbed.h"
#include "SRF02.h"
#include "N5110.h"
#include "beep.h" ///@see a library I found to initiate the buzzer 
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"

#define USR_POWERDOWN (0x104)
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);
SRF02 sensor(p28, p27);
/**  
@namespace buzzer
@brief output for status buzzer
*/
Beep buzzer(p21);
/**  
@namespace green1
@brief GPIO output for status LED
*/
PwmOut green1(p22);
/**  
@namespace green2
@brief GPIO output for status LED
*/
PwmOut green2(p23);
/**  
@namespace yellow1
@brief GPIO output for status LED
*/
PwmOut yellow1(p24);
/**  
@namespace yellow2
@brief GPIO output for status LED
*/
PwmOut yellow2(p25);
/**  
@namespace red1
@brief GPIO output for status LED
*/
DigitalOut red1(p29);
/**  
@namespace red2
@brief GPIO output for status LED
*/
DigitalOut red2(p30);
/**  
@namespace pot
@brief GPIO input for lcd brightness
*/
AnalogIn mypot(p20);
/**  
@namespace button
@brief GPIO input to switch values from the sensor
*/
InterruptIn button(p15);


Serial pc(USBTX, USBRX);



void beepOff();

void beepOn(float t);

/**
Shows the welcome message when the LCD is on
*/
void welcomeMessage();
/**
gets the distance in cm by dividing 
10 read values by 10
@returns the average distance in cm
*/
void getDistanceCm();
/**
gets the distance in inches by dividing 
10 read values by 10
@returns the average distance in inches
*/
void getDistanceIn();
/**
gets the distance in us by dividing 
10 read values by 10
@returns the average distance in us
*/
void getDistanceUs();

/**
when the button is pressed this 
action is called
*/
void buttonPressed();
/**
looks for where the range of the reading is 
to set its conditions
*/
void compDist();
/**
compares the cases of each distance
to set the Led's values and the buzzer
*/
void distanceA();


int distanceCm; /*!< distanceCm set in ISR */
int distanceIn; /*!< distanceIn set in ISR */
int distanceUs; /*!< distanceUs set in ISR */
int A;   /*!< used to compare the cases after being set in compDist() */

/**
All distances used to add 
the 10 readings from the sensor
to get an average of 10 readings
per second, so that it will cancel 
out the noise.
*/
int distance1;   /*!< distance1 set in ISR */
int distance2;   /*!< distance2 set in ISR */
int distance3;   /*!< distance3 set in ISR */
int distance4;   /*!< distance4 set in ISR */
int distance5;   /*!< distance5 set in ISR */
int distance6;   /*!< distance6 set in ISR */
int distance7;   /*!< distance7 set in ISR */
int distance8;   /*!< distance8 set in ISR */
int distance9;   /*!< distance9 set in ISR */
int distance10;  /*!< distance10 set in ISR */

float mypotVal;  /*!< mypotVal is used to transfer the vlaue of the pot
                       to lcd brightness */
int i=0;
int sum; /*!< used to add all the distances together (ie distance 1,
          distance 2, ...*/
#endif