/**
@file main.cpp

@brief Program implementation

*/

#include "main.h"



int main()
{  
 

    PHY_PowerDown();   /// the Ethernet cable is powered down
    lcd.init();        /// the LCD display is initialised when switch is on
    welcomeMessage();  /// the welcome message will appear
    button.rise(&buttonPressed); /// event generated on rising edge
   

    while (1) {
       
         mypotVal = mypot; ///sets a variable to change as the pot is changing
         lcd.setBrightness(mypotVal);  ///sets the brightness to the pot value       
         compDist(); ///compares the distance to set it in a specific range

                     
       }


}

void buttonPressed() 
{
    wait(0.2); 
    
    if (i>1) ///when button is pressed it will check if i >1 
    {   i=0; /// if it is it will set it to 0
    }
    else 
      {  i++; /// if not it will increment i by one
        }
        
}



 ///Print welcome message
void welcomeMessage()
{
    
   
        lcd.printString("University of ",5,0);
        lcd.printString("Leeds",27,1);
        
        lcd.refresh();
        
        lcd.drawRect(59,36,5,11,0);///bottom left rectangle is set
        lcd.drawRect(72,36,5,11,0);///bottom right rectangle is set
        lcd.drawRect(64,34,8,13,0);///bottom middle rectangle is set
        
        lcd.drawRect(60,33,16,3,0); /// is set over the bottom rectangles 
        
        lcd.drawCircle(68,40,2,0); /// circle is set on bottom middle box
        
        lcd.drawRect(61,26,14,7,0);///big middle box is set over everything
        
        lcd.drawRect(63,27,10,0.5,1);///top black rectangle is set
        
        lcd.drawRect(64.5,28,1,0.5,1);///left middle black rect is set
        lcd.drawRect(67.5,28,1,0.5,1);///middle black rect is set
        lcd.drawRect(70,28,1,0.5,1);///right middle black rect is set
        lcd.drawRect(64.5,28,0.5,3.5,1);///left bottom black rect is set
        lcd.drawRect(67.5,28,0.5,3.5,1);///middle bottom black rect is set 
        lcd.drawRect(70,28,0.5,3.5,1);///right bottom black rect is set
        
        lcd.drawRect(62,21,12,5,0);///rectangle is set over big middle box 
        
        lcd.drawRect(66,22,0.5,0.5,1);///left top black rect is set
        lcd.drawRect(68,22,0.5,0.5,1);///top black rect is set
        lcd.drawRect(70,22,0.5,0.5,1);///right top black rect is set
        lcd.drawRect(66,22,0.5,2,1);///left bottom black rect is set
        lcd.drawRect(68,22,0.5,2,1);///middle bottom black rect is set
        lcd.drawRect(70,22,0.5,2,1);///right bottom black rect is set
        
        lcd.drawRect(64,17,8,4,0);///rectangle under triangle is set
        
        lcd.drawLine(64,17,68,13.5,1);///left line to complete triangle
        
        lcd.drawLine(72,17,68,13.5,1);///right line to complete triangle

        
        
        lcd.clearPixel(65, 36);  ///clears intersecting lines from rectangle
         lcd.clearPixel(66, 36);
          lcd.clearPixel(67, 36);
           lcd.clearPixel(68, 36);
            lcd.clearPixel(69, 36);
             lcd.clearPixel(70, 36);
              lcd.clearPixel(71, 36);
              
         lcd.refresh();     
              
   
                           
    wait(3.0);
    lcd.clear();
   
   
   
          lcd.printString("Saleh Jaffal",8,2);
          lcd.printString("200911007",15,3);
            
              lcd.refresh();

          lcd.drawRect(6,12,73,21,0);
          lcd.drawRect(4,10,77,25,0);
          
              lcd.refresh();

    
          
    getDistanceCm(); ///gets the distance after the message
    getDistanceIn();
    getDistanceUs();
    
    

}

void getDistanceCm()
{
    
    distance1 = sensor.getDistanceCm(); ///adds up 10 distances read by the sensor
    distance2 = sensor.getDistanceCm(); ///there is a 70 ms delay between each reading
    distance3 = sensor.getDistanceCm();
    distance4 = sensor.getDistanceCm();
    distance5 = sensor.getDistanceCm();
    distance6 = sensor.getDistanceCm();
    distance7 = sensor.getDistanceCm();
    distance8 = sensor.getDistanceCm();
    distance9 = sensor.getDistanceCm();
    distance10 = sensor.getDistanceCm();
    
      sum = distance1+distance2+distance3+distance4+distance5+distance6+distance7+distance8+distance9+distance10;
        ///all of them are added to the sum
       
        distanceCm = sum/10; ///the sum is divided by 10 to get the average
        }
        
        
        
        



void getDistanceIn()
{
    distance1 = sensor.getDistanceIn();    ///adds up 10 distances read by the sensor
    distance2 = sensor.getDistanceIn();    ///there is a 70 ms delay between each reading
    distance3 = sensor.getDistanceIn();
    distance4 = sensor.getDistanceIn();
    distance5 = sensor.getDistanceIn();
    distance6 = sensor.getDistanceIn();
    distance7 = sensor.getDistanceIn();
    distance8 = sensor.getDistanceIn();
    distance9 = sensor.getDistanceIn();
    distance10 = sensor.getDistanceIn();
    
    
        sum = distance1+distance2+distance3+distance4+distance5+distance6+distance7+distance8+distance9+distance10;
         ///all of them are added to the sum
         
        distanceIn = sum/10; ///the sum is divided by 10 to get the average
        }
        
     

void getDistanceUs()
{
    distance1 = sensor.getDistanceUs();  ///adds up 10 distances read by the sensor
    distance2 = sensor.getDistanceUs();  ///there is a 70 ms delay between each reading
    distance3 = sensor.getDistanceUs();
    distance4 = sensor.getDistanceUs();
    distance5 = sensor.getDistanceUs();
    distance6 = sensor.getDistanceUs();
    distance7 = sensor.getDistanceUs();
    distance8 = sensor.getDistanceUs();
    distance9 = sensor.getDistanceUs();
    distance10 = sensor.getDistanceUs();
    
    
        sum = distance1+distance2+distance3+distance4+distance5+distance6+distance7+distance8+distance9+distance10;
        ///all of them are added to the sum
        
        distanceUs = sum/10;  ///the sum is divided by 10 to get the average
       
        
}

void  compDist()  ///used to compare the distances
{
        
switch (i) 
{
        
       case 0:
     {
        getDistanceCm();
         ///calls this action to show the reading
        char buffer[14]; 
        /// each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        int length = sprintf(buffer," %d cm",distanceCm);
        /// print formatted data to buffer
        if(length<=14);
        /// if string will fit on display
       
        lcd.clear(); /// clears LCD
        lcd.drawRect(6,12,73,21,0);///sets 2 rectangles
        lcd.drawRect(4,10,77,25,0);
        lcd.printString("Distance =",8,2);///prints distance and the reading below it
        lcd.printString(buffer,8,3);
        
        lcd.refresh(); ///refreshes LCD screen
       
       
      
        ///compares distances and sets them in their specified range
     if (distanceCm >= 100) {
          A=0;    ///sets case
        distanceA();
    }
    else if (distanceCm >= 80  && distanceCm <= 99) {
          A=1;   ///sets case
        distanceA();
    }
    else if (distanceCm >= 60 && distanceCm <= 79) {
         A=2;   ///sets case
        distanceA();
    }
    else if (distanceCm >= 40 && distanceCm <= 59) {
          A=3;   ///sets case
        distanceA();
    }
    else if (distanceCm >= 20 && distanceCm <=39 ) {
         A=4;    ///sets case
        distanceA();
    }
    else   {
          A=5;  ///sets case
        distanceA();
            }

     }
             break;
             
 case (1):
{        

         getDistanceIn();
         ///calls this action to show the reading
        char buffer[14]; 
        /// each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        int length = sprintf(buffer," %d in",distanceIn);
        /// print formatted data to buffer
        if(length<=14);
        /// if string will fit on display
       
        lcd.clear(); /// clears LCD
        lcd.drawRect(6,12,73,21,0);/// sets 2 rectangles
        lcd.drawRect(4,10,77,25,0);
        lcd.printString("Distance =",8,2);/// prints distance and the reading below it
        lcd.printString(buffer,8,3);
        
        lcd.refresh(); /// refreshes LCD screen
        
      ///compares distances and sets them in their specified range

     if (distanceIn >= 40) {
          A=0;   ///sets case
        distanceA();
    }
    else if (distanceIn >= 32  && distanceIn <= 39) {
          A=1;   ///sets case
        distanceA();
    }
    else if (distanceIn >= 24 && distanceIn <= 31) {
         A=2;   ///sets case
        distanceA();
    }
    else if (distanceIn >= 16 && distanceIn <= 23) {
          A=3;   ///sets case
        distanceA();
    }
    else if (distanceIn >= 8 && distanceIn <=15 ) {
         A=4;   ///sets case
        distanceA();
    }
    else   {
          A=5;   ///sets case
        distanceA();
           }                       
   }
        break;
                 
      case(2): 
          {
         getDistanceUs();
         ///calls this action to show the reading
        char buffer[14]; 
        /// each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        int length = sprintf(buffer," %d us",distanceUs);
        /// print formatted data to buffer
        if(length<=14);
        /// if string will fit on display
       
        lcd.clear(); /// clears LCD
        lcd.drawRect(6,12,73,21,0);/// sets 2 rectangles
        lcd.drawRect(4,10,77,25,0);
        lcd.printString("Distance =",8,2);/// prints distance and the reading below it
        lcd.printString(buffer,8,3);
        
        lcd.refresh(); /// refreshes LCD screen
        
        
      ///compares distances and sets them in their specified range

     if (distanceUs >= 5900) {
          A=0; ///sets case
        distanceA();
    }
    else if (distanceUs >= 4680  && distanceUs <= 5899) {
          A=1;///sets case
        distanceA();
    }
    else if (distanceUs >= 3400 && distanceUs <= 4679) {
         A=2;///sets case
        distanceA();
    }
    else if (distanceUs >= 2430 && distanceUs <= 3339) {
          A=3;///sets case
        distanceA();
    }
    else if (distanceUs >= 1220 && distanceUs <=2429 ) {
         A=4;///sets case
        distanceA();
    }
    else   {
          A=5;///sets case
        distanceA();
           }                   
              
    }
     break;
              
              

       }          
       }

void distanceA() //sets leds and buzzer for each case
{
    switch (A){
        
    case(0):
    {                //case 0 would have 1 LED on
    green1=1;
    green2=0;
    yellow1=0;
    yellow2=0;
    red1=0;
    red2=0;
    lcd.printString("Out of range",0,0);
     buzzer.beep(2000, 0.1); ///@see This code was from a library I found
    

} 
break;

case(1):
{               ///case 1 would have 2 LED's on
    green1=1;
    green2=1;
    yellow1=0;
    yellow2=0;
    red1=0;
    red2=0;
    lcd.printString("In range",0,0);
    buzzer.beep(2000, 0.1); ///@see This code was from a library I found
}
break;

case(2):
{   //green1=1;       ///case 2 would have 3 LED's on
    green2=1;
    yellow1=1;
    yellow2=0;
    red1=0;
    red2=0;
    lcd.printString("Take Care!",0,0);
    buzzer.beep(2000, 0.2);
}
break;

case(3):
{
    green1=1;      ///case 3 would have 4 LED's on
    green2=1;
    yellow1=1;
    yellow2=1;
    red1=0;
    red2=0;
    lcd.printString("Closer!",0,0);
    buzzer.beep(2000, 0.2); ///@see This code was from a library I found
}
break;

case(4):
{
    green1=1;      ///case 4 would have 5 LED's on
    green2=1;
    yellow1=1;
    yellow2=1;
    red1=1;
    red2=0;
    lcd.printString("VERY CLOSE!",0,0);
    buzzer.beep(2000, 0.4); ///@see This code was from a library I found
}
break;

case(5):
{
    green1=1;       ///case 5 would have 6 LED's on
    green2=1;
    yellow1=1;
    yellow2=1;
    red1=1;
    red2=1;
    lcd.printString("WATCH OUT!",0,0);
    buzzer.beep(2000, 1.2); ///@see This code was from a library I found
}
break;
}}