#include "mbed.h"

//mbed Declaration left here as example 
AnalogIn analog_value(A0);

DigitalOut led(LED1);

//ST HAL For ADC since we want to access the internal channels
ADC_HandleTypeDef hadc1;

int main() {
    float meas;
    
    ADC_ChannelConfTypeDef sConfig;  //Declare the ST HAL ADC object
    
    /**Configure the global features of the ADC (Clock, Resolution, Data Alignment and number of conversion) 
    */
    hadc1.Instance = ADC1;
    hadc1.Init.ClockPrescaler = ADC_CLOCKPRESCALER_PCLK_DIV4;
    hadc1.Init.Resolution = ADC_RESOLUTION12b;
    hadc1.Init.ScanConvMode = DISABLE;
    hadc1.Init.ContinuousConvMode = DISABLE;
    hadc1.Init.DiscontinuousConvMode = DISABLE;
    hadc1.Init.ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_NONE;
    hadc1.Init.DataAlign = ADC_DATAALIGN_RIGHT;
    hadc1.Init.NbrOfConversion = 1;
    hadc1.Init.DMAContinuousRequests = DISABLE;
    hadc1.Init.EOCSelection = EOC_SINGLE_CONV;
    HAL_ADC_Init(&hadc1);   //Go turn on the ADC
    
    sConfig.Channel = ADC_CHANNEL_TEMPSENSOR; //ADC_CHANNEL_VREFINT, ADC_CHANNEL_VBAT
    sConfig.Rank = 1;
    sConfig.SamplingTime = ADC_SAMPLETIME_3CYCLES;

    printf("\nAnalogIn example\n");
    
    while(1) {
        meas = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        meas = meas * 3300; // Change the value to be in the 0 to 3300 range
        printf("A0 input: measure = %.0f mV\n", meas);
        if (meas > 2000) { // If the value is greater than 2V then switch the LED on
          led = 1;
        }
        else {
          led = 0;
        }
        wait(0.2); // 200 ms

//Now go read the STM internal channel selected above
        HAL_ADC_ConfigChannel(&hadc1, &sConfig);
        HAL_ADC_Start(&hadc1); // Start conversion
    
        // Wait end of conversion and get value
        if (HAL_ADC_PollForConversion(&hadc1, 10) == HAL_OK) {
            uint16_t value = HAL_ADC_GetValue(&hadc1);
            printf("Internal Channel Value = %04X\n\r",value);
        } else {
            error("Conversion Error");
        }

    }
}
