#include <iostream>
#include <cstdio>
#include <ctime>
#include "MODSERIAL.h"
#include "stdio.h"
#include "mbed.h" //standaard bieb mbed
#include "QEI.h"  //bieb voor encoderfuncties in c++
InterruptIn sw3(D9);
DigitalIn encoder1A(D13);
DigitalIn encoder1B(D12);
DigitalIn encoder2A(D11); 
DigitalIn encoder2B(D10);
DigitalIn button_cw(SW2);
DigitalIn button_ccw(SW3);
MODSERIAL pc(USBTX, USBRX);
DigitalOut richting_motor1(D4);
PwmOut pwm_motor1(D5);
DigitalOut richting_motor2(D7);
PwmOut pwm_motor2(D6);

volatile double current_position = 0;                // current position is 0 op het begin
volatile double previous_position = 0;               // previous position is 0 op het begin                     
volatile bool tickerflag;                           //bool zorgt er voor dat de tickerflag alleen 1 of 0 kan zijn (true or false)
volatile double snelheid;
double ticker_TS=0.01;                              // zorgt voor een tijdstap van de ticker van 0.01 seconde
volatile double timepassed=0;                       //de waarde van hoeveel tijd er verstreken is
Ticker t;                                           // maakt ticker t aan

const int CW = 2.5; //definitie rechtsom 'lage waarde'
const int CCW =0; //definitie linksom 'hoge waarde'
const float gearboxratio=131.25; // gearboxratio van encoder naar motor
const int rev_rond=32;        // aantal revoluties per omgang van de encoder

const float a=10.0; //voltingang motor 1
 const float b=10.0;//voltingang motor 2
 
    

void tickerfunctie()                // maakt een ticker functie aan
{
tickerflag = 1;                     // het enige wat deze functie doet is zorgen dat tickerflag 1 is
}

int main()
{
    pc.baud(115200);
    QEI Encoder2(D12,D13, NC, rev_rond);  // maakt een encoder aan! D12/D13 ingangen, rev_rond zijn aantal pulsen per revolutie! Bovenaan in te stellen. 
  QEI Encoder1(D10,D11, NC, rev_rond);
    float counts_encoder1;                  //variabele counts aanmaken
    float rev_counts_motor1;                   //variabele motor rondjes aanmaken in radialen!!
    float counts_encoder2;
    float rev_counts_motor2;
    t.attach(&tickerfunctie,ticker_TS);             // attacht de ticker met een tick van 0.01 seconde (gelijk aan de tijdstap)
    while (true){           
    if (button_cw==0)  {                            // als knopje wordt ingedrukt
       if ( tickerflag == 1)                        // als de ticker flag 1 is gaat dit loopje lopen. 
       {
        richting_motor1 = CW;
           pwm_motor1 = a; 
           
           counts_encoder1 = Encoder1.getPulses(); //tellen van de pulsen in  
           rev_counts_motor1=counts_encoder1/(gearboxratio*rev_rond);              //berekenen van het aantal rondjes van motor. Gedeeld door gearboxratio en rev rond, om naar motorrondjes te gaan in plaats van pulsen van encoder!
           pc.printf("motor rondjes motor1: %f \r\n", rev_counts_motor1); 
           
        previous_position = current_position;
        current_position = rev_counts_motor1;
        
        snelheid = ((current_position - previous_position)*6.28318530718) / ticker_TS;
        pc.printf("snelheid is: %f \r\n", snelheid);
        
        tickerflag = 0;
        }
    
    }
    else{
        pwm_motor2=0;
    pwm_motor1=0;
        }
    }
}