//=====================================================================================
//libraries
#include "mbed.h"           //mbed revision 113
#include "HIDScope.h"       //Hidscope by Tom Lankhorst
#include "BiQuad.h"         //BiQuad by Tom Lankhorst
#include "MODSERIAL.h"      //Modserial
#include "QEI.h"            //QEI library for the encoders


//=====================================================================================
//Define objects

//EMG
AnalogIn    emg_biceps_right_in (A0);               //analog in to get EMG biceps  (r) in to c++
AnalogIn    emg_triceps_right_in(A1);               //analog in to get EMG triceps (r) in to c++
AnalogIn    emg_biceps_left_in  (A2);               //analog in to get EMG biceps  (l) in to c++

//Tickers
Ticker      sample_timer;               //ticker for EMG signal sampling, analog becomes digital
Ticker      ticker_switch;              //ticker for switch, every second it is possible to switch
Ticker      ticker_referenceangle;      //ticker for the reference angle
Ticker      ticker_controllerm1;        //ticker for the controller (PID) of motor 1

//Monitoring
HIDScope    scope(5);                   //open 5 channels in hidscope
MODSERIAL pc(USBTX, USBRX);             //pc connection
DigitalOut red(LED_RED);                //LED on K64F board, 1 is out; 0 is on
DigitalOut green(LED_GREEN);            //LED on K64f board, 1 is out; o is on

//motors
DigitalOut richting_motor1(D7);         //motor 1 connected to motor 1 at k64f board; for turningtable
PwmOut pwm_motor1(D6);
DigitalOut richting_motor2(D4);         //motor 2 connected to motor 2 at k64f board; for linear actuator
PwmOut pwm_motor2(D5);

//encoders
DigitalIn encoder1A(D13);
DigitalIn encoder1B(D12);
DigitalIn encoder2A(D11);
DigitalIn encoder2B(D10);

//controller
BiQuad PID_controller;


//=====================================================================================
//define variables

//thresholds
double treshold_biceps_right = 0.04;                 //common values that work.
double treshold_biceps_left = -0.04;                 // tested on multiple persons 
double treshold_triceps = -0.04;                     //triceps and left biceps is specified negative, thus negative treshold

//on/off and switch signals
int switch_signal = 0; //start of counter, switch made by even and odd numbers
int onoffsignal_biceps; 
int switch_signal_triceps;

//motorvariables
float speedmotor1=0.18; //speed of motor 1 is 0.18pwm at start
float speedmotor2=1.0;  //speed of motor 2 is 1.0 pwm at start

int cw=0;               //clockwise direction
int ccw=1;              //counterclockwise direction

//encoder
int counts_encoder1;
//int counts_encoder2;
float rev_counts_motor1;
float rev_counts_motor1_rad;
const float gearboxratio=131.25;    // gearboxratio van encoder naar motor
const float rev_rond=64.0;          // aantal revoluties per omgang van de encoder

//reference
volatile float d_ref = 0;
const float w_ref = 3;
const double Ts = 0.001;

//controller
const double Kp = 0.3823;
const double Ki = 0.1279;
const double Kd = 0.2519;
const double N = 100;
volatile double error1;
volatile double controlOutput; 
//=======================================
//filter coefficients

//b1 = biceps right arm
BiQuad filterhigh_b1(9.5654e-01,-1.9131e+00,9.5654e-01,-1.9112e+00,9.1498e-01);                 // second order highpass filter, with frequency of?
BiQuad filternotch1_b1 (9.9376e-01 , -1.8902e-00,   9.9376e-01 , -1.8902e-00 ,  9.875e-01);     // second order notch filter, with frequency of?

//t1= triceps right arm
BiQuad filterhigh_t1(9.5654e-01,-1.9131e+00,9.5654e-01,-1.9112e+00,9.1498e-01);                  // second order highpass filter, with frequency of?
BiQuad filternotch1_t1 (9.9376e-01 , -1.8902e-00,   9.9376e-01 , -1.8902e-00 ,  9.875e-01);      // second order notch filter, with frequency of?

//b2= biceps left arm
BiQuad filterhigh_b2(9.5654e-01,-1.9131e+00,9.5654e-01,-1.9112e+00,9.1498e-01);                  // second order highpass filter, with frequency of?
BiQuad filternotch1_b2 (9.9376e-01 , -1.8902e-00,   9.9376e-01 , -1.8902e-00 ,  9.875e-01);      // second order notch filter, with frequency of?

//after abs filtering
BiQuad filterlow_b1 (6.2942e-06, 1.2588e-05,6.2942e-06,-1.9929e+00,9.9292e-01);                 // second order lowpass filter, with frequency of?
BiQuad filterlow_t1 (6.2942e-06, 1.2588e-05,6.2942e-06,-1.9929e+00,9.9292e-01);                 // second order lowpass filter, with frequency of?
BiQuad filterlow_b2 (6.2942e-06, 1.2588e-05,6.2942e-06,-1.9929e+00,9.9292e-01);                 // second order lowpass filter, with frequency of?

//======================================================================
//voids
//======================================================================

//function teller
void switch_function() {                        // The switch function. Makes it possible to switch between the motors. It simply adds one at switch_signal.
    if(switch_signal_triceps==1)
    {
        switch_signal++;
           
    // To monitor what is happening: we will show the text in putty  and change led color from red to green or vice versa.
    
        green=!green;
        red=!red;
        
    if (switch_signal%2==0)  
     {pc.printf("If you contract the biceps, the robot will go right \r\n");    
     pc.printf("If you contract the triceps, the robot will go left \r\n");
     pc.printf("\r\n");
     }
       
    
    else
     {pc.printf("If you contract the biceps, the robot will go up \r\n");
     pc.printf("If you contract the triceps, the robot will go down \r\n");
    pc.printf("\r\n");
     }
     
    }    
    }
 
//======================================================================   
//functions which are called in ticker to sample the analog signal and make the on/off and switch signal. 

void filter(){
        //biceps right arm read+filtering
       double emg_biceps_right=emg_biceps_right_in.read();                                                      //read the emg value from the elektrodes 
       double emg_filtered_high_biceps_right= filterhigh_b1.step(emg_biceps_right);                             //high pass filter, to remove offset
       double emg_filtered_high_notch_1_biceps_right=filternotch1_b1.step(emg_filtered_high_biceps_right);      //notch filter, to remove noise
       double emg_abs_biceps_right=fabs(emg_filtered_high_notch_1_biceps_right);                                //rectify the signal, fabs because float   
       double emg_filtered_biceps_right=filterlow_b1.step(emg_abs_biceps_right);                                //low pass filter to envelope the signal
        
        //triceps right arm read+filtering
       double emg_triceps_right=emg_triceps_right_in.read();                                                    //read the emg value from the elektrodes
       double emg_filtered_high_triceps_right= filterhigh_t1.step(emg_triceps_right);                           //high pass filter, to remove offset
       double emg_filtered_high_notch_1_triceps_right=filternotch1_t1.step(emg_filtered_high_triceps_right);    //notch filter, to remove noise
       double emg_abs_triceps_right=fabs(emg_filtered_high_notch_1_triceps_right);                              //rectify the signal, fabs because float   
       double emg_filtered_triceps_right=filterlow_t1.step(emg_abs_triceps_right);                              //low pass filter to envelope the signal
        
        //biceps left arm read+filtering
       double emg_biceps_left=emg_biceps_left_in.read();                                                    //read the emg value from the elektrodes
       double emg_filtered_high_biceps_left= filterhigh_b2.step(emg_biceps_left);                           //high pass filter, to remove offset
       double emg_filtered_high_notch_1_biceps_left=filternotch1_b2.step(emg_filtered_high_biceps_left);    //notch filter, to remove noise
       double emg_abs_biceps_left=fabs(emg_filtered_high_notch_1_biceps_left);                              //rectify the signal, fabs because float   
       double emg_filtered_biceps_left=filterlow_b2.step(emg_abs_biceps_left);                              //low pass filter to envelope the signal
               
        //creating of on/off signal with the created on/off signals, with if statement   for right arm!    
       //signal substraction of filter biceps and triceps. right Biceps + left biceps -
       double signal_biceps_sum=emg_filtered_biceps_right-emg_filtered_biceps_left;
       double bicepstriceps_rightarm=emg_filtered_biceps_right-emg_filtered_triceps_right;       
        
        //creating of on/off signal with the created on/off signals, with if statement   for right arm!    
            if (signal_biceps_sum>treshold_biceps_right)
            {onoffsignal_biceps=1;}
          
            else if (signal_biceps_sum<treshold_biceps_left)
            {        onoffsignal_biceps=-1;       }    
        
            else
            {onoffsignal_biceps=0;}
                      
        //creating on/off signal for switch (left arm)
        
            if (bicepstriceps_rightarm<treshold_triceps)
        {        switch_signal_triceps=1;            }    
        
        else
        {        switch_signal_triceps=0;       }
        
        //send signals  to scope to monitor the EMG signals
        scope.set(0, emg_filtered_biceps_right);                    //set emg signal of right biceps to scope in channel 0
        scope.set(1, emg_filtered_triceps_right);                   // set emg signal of right triceps to scope in channel 1
        scope.set(2, emg_filtered_biceps_left);                     // set emg signal of left biceps to scope in channel 2
        scope.set(3, onoffsignal_biceps);                           // set on/off signal for the motors to scope in channel 3
        scope.set(4, switch_signal_triceps);                        // set the switch signal to scope in channel 4 
        
        scope.send();                       //send all the signals to the scope
                }
                
void reference(){
    if (onoffsignal_biceps==-1 && switch_signal%2==0){ //switch even       //right biceps contracted{
         d_ref = d_ref + w_ref * Ts;
    }
         if (d_ref > 8){
            d_ref = 8;
            //d_ref_const_cw = 1;
        }
    else{ 
        d_ref = d_ref;
    }
    
    if (onoffsignal_biceps==1 && switch_signal%2==0){ //switch even    //left biceps contracted{
        d_ref = d_ref - w_ref * Ts;
    }
        if (d_ref < -8){
        d_ref = -8;
        
    }
    else{
        d_ref = d_ref;
    }
    
}

void m1_controller(){
    error1 = d_ref-rev_counts_motor1_rad;
    controlOutput = PID_controller.step(error1);
}

//======================================================================   
//program
//======================================================================   
int main()
{  

pc.baud(115200); //connect with pc with baudrate 115200
green=1;         //led is off (1), at beginning  
red=0;           //led is on (0), at beginning

//attach tickers to functions
sample_timer.attach(&filter, Ts);        //continously execute the EMG reader and filter, it ensures that filter and sampling is executed every 1/frequency seconds
ticker_switch.attach(&switch_function,1.0);
ticker_referenceangle.attach(&reference, Ts);
ticker_controllerm1.attach(&m1_controller, Ts);

//PID controller
PID_controller.PIDF(Kp,Ki,Kd,N,Ts);

//Encoder
QEI Encoder1(D13,D12, NC, rev_rond,QEI::X4_ENCODING);

//Show the user what the starting motor will be and what will happen
pc.printf("We will start the demonstration\r\n");
pc.printf("\r\n\r\n\r\n");

    if (switch_signal%2==0)  
     {pc.printf("If you contract the biceps, the robot will go right \r\n");
     pc.printf("If you contract the triceps, the robot will go left \r\n");
      pc.printf("\r\n");
     }
       
    
    else
     {pc.printf("If you contract the biceps, the robot will go up \r\n");
     pc.printf("If you contract the triceps, the robot will go down \r\n");
      pc.printf("\r\n");
     }
     
//==============================================================================================
//endless loop


    while (true) {                        // neverending loop
        
counts_encoder1 = Encoder1.getPulses();
rev_counts_motor1=(float)counts_encoder1/(gearboxratio*rev_rond); 
rev_counts_motor1_rad=rev_counts_motor1*6.28318530718; 

pc.printf("%f \r\n", d_ref);
pc.printf("%f ", rev_counts_motor1_rad);

    if (onoffsignal_biceps==-1)  //left biceps contracted                        
    {
         if (switch_signal%2==0) //switch even                    
         { 
            speedmotor1=controlOutput;
            //richting_motor1 = ccw;    //motor 1, left
            //pwm_motor1 = speedmotor1; //speed of motor 1
            if (speedmotor1<0){
                richting_motor1 = cw;
                }
            else   {
                richting_motor1 = ccw;
                }
                pwm_motor1 = fabs(speedmotor1);      //speed of motor 1
               // pc.printf("%f\r\n", pwm_motor1.read());
         } 
            
         
         else                       //switch odd        
         {
           richting_motor2 = ccw;   //motor 2, up 
           pwm_motor2 = speedmotor2;//speed of motor 2
           
         }      
              
    }
    else if (onoffsignal_biceps==1)                  //right biceps contracted
    {
         if (switch_signal%2==0)                     //switch signal even
         {
           speedmotor1=controlOutput;
            //richting_motor1 = ccw;    //motor 1, left
            //pwm_motor1 = speedmotor1; //speed of motor 1
            if (speedmotor1<0){
                richting_motor1 = cw;
                }
            else   {
                richting_motor1 = ccw;
                }
                pwm_motor1 = fabs(speedmotor1);      //speed of motor 1
          // pc.printf("%f\r\n", pwm_motor1.read());
        } 
         else                         //switch signal odd
         {
           richting_motor2 = cw;        //motor 2. down
           pwm_motor2 = speedmotor2;    //speed motor 2
                
         }  
    }   
    else{ 
    //no contraction of biceps   
    pwm_motor2=0;
    pwm_motor1=0;
       }              
               
}//while true closed
        
} //int main closed

//=============================================================================================1