#include "HttpHandlerUsbBrowser.h"
#include "USBHost.h"
#include "Utils.h"
#include "UsbStorage.h"

HttpHandlerUsbBrowser::HttpHandlerUsbBrowser(const char* rootPath, const char* path, TCPSocket* pTCPSocket) :
 HTTPRequestHandler(rootPath, path, pTCPSocket)
{
  //printf("HttpHandlerUsbBrowser()");
}

HttpHandlerUsbBrowser::~HttpHandlerUsbBrowser()
{
}

void HttpHandlerUsbBrowser::doGet()
{
  int cmpRes = path().compare(0, 5, "/root");
  printf("doGet path:%d\r\n", cmpRes);    
  
  DIR*  d = 0;
  FILE* f = 0;
  
  char usbFullPath[256] = "/usb";
  if (cmpRes == 0)
  {
    path().copy(usbFullPath + 4, 252, 5);
    int usbFullPathLen = strlen(usbFullPath);
    if (usbFullPath[usbFullPathLen - 1] == '/') usbFullPath[usbFullPathLen - 1] = 0;
 
    d = opendir(usbFullPath);
    //printf("after open dir\r\n");
    
    if (!d) f = fopen(usbFullPath, "r");
    //printf("after open file\r\n");
  }
  
  if (!d && !f)
  {    
    printf("return no data\r\n");
    respHeaders()["Connection"] = "close";
    writeData("<html><body>No Data or Invalid Path</html></body>", 49);  
    setContentLen(49);
    return;
  }

  const char* resp1 = 
    "<html><body>"
    "<p><span style=\"color: #a9a9a9\"><span style=\"font-size: 12px\">DropBox Sync Flash-Explorer</span></span></p>";
   
  const char* resp2 =
    "</form><p>&nbsp;</p>"
    "<p><strong><span style=\"color: #000080\">BDDB Ltd.</span></strong></p>"
    "</body>"
    "</html>";
  
  int l1 = strlen(resp1), l2 = strlen(resp2);
  int length = l1 + l2; 
  
  int t1 = writeData(resp1, l1);
  
  if (d)
  {
      printf("\nDumping root dir\n\r");
      struct dirent *dir = readdir(d);
      while (dir)
      {
        int len = sizeof(dirent);
        printf("%s %d\n\r", dir->d_name, len);
      
        int nameLen = strlen(dir->d_name);
      
        writeData("<p><a href=\"", 12);
        writeData(dir->d_name, nameLen);
        writeData("/\">", 3);
        writeData(dir->d_name, nameLen);
        writeData("</a></p>", 8);
        length += nameLen * 2 + 23;
      
        dir = readdir(d);
      }
      closedir(d);
  }
  else if (f)
  {
    printf("dumping file \r\n");
    while (fgets(usbFullPath, 256, f) && length <= 4096)
    {
     // printf("%s\r\n", usbFullPath);
      int len = strlen(usbFullPath);
      writeData(usbFullPath, len);
      
      length += len;
    }
    
    fclose(f);
  }

  int t3 = writeData(resp2, l2);
  respHeaders()["Connection"] = "close";  
  setContentLen(length);
  
  printf("doGet()-end length %d\r\n", length);
}

void HttpHandlerUsbBrowser::doPost()
{
  printf("doPost()\r\n");
}

void HttpHandlerUsbBrowser::doHead()
{
  printf("onHead\r\n");
}
  
void HttpHandlerUsbBrowser::onReadable() //Data has been read
{
  printf("onReadable\r\n");
}

void HttpHandlerUsbBrowser::onWriteable() //Data has been written & buf is free
{
  printf("onWriteable\r\n");
  close(); //Data written, we can close the connection
}

void HttpHandlerUsbBrowser::onClose() //Connection is closing
{
  //Nothing to do
}
