#include "HTTPServer.h"

#ifndef HTTP_HANDLER_SETUP
#define HTTP_HANDLER_SETUP

// Read password and username from the settting file (/usb/DBSet.txt)
bool ReadSettings(char* username, char* password);

// Http handler that provides welcome and setup pages
class HttpHandlerSetup : public HTTPRequestHandler
{
public:
  HttpHandlerSetup(const char* rootPath, const char* path, TCPSocket* pTcpSocket);
  virtual ~HttpHandlerSetup();
  
  static inline HTTPRequestHandler* inst(const char* rootPath, const char* path, TCPSocket* pTcpSocket) { return new HttpHandlerSetup(rootPath, path, pTcpSocket); }
protected:

  virtual void doGet();
  virtual void doPost();
  virtual void doHead();
  
  virtual void onReadable(); //Data has been read
  virtual void onWriteable(); //Data has been written & buf is free
  virtual void onClose(); //Connection is closing

private:
  void doGetPageWelcome(); // Called from doGet(), get the welcome webpage
  void UpdateSettingsFile(); // Updates the username and password in the settings file
  
  bool m_WasDataRead;
};

#endif