#include "HTTPFileSender.h"
#include "USBHost.h"

char HTTPFileSender::header[] = "";
char HTTPFileSender::footer[] = "\r\n\r\n--R50hrfBj5JYyfR3vF3wR96GPCC9Fd2q2pVMERvEaOE3D8LZTgLLbRpNwXek3--\r\n";

HTTPFileSender::HTTPFileSender(const char *fileName, const char *dstFile)
{
    pos = 0;
    
    printf("Opening %s\n\r", fileName);
    
    file = fopen(fileName, "r");
    
    printf("Opened %d\n\r", file);
    
    fseek(file, 0L, SEEK_END);
    printf("seek1\r\n");
    fileLen = ftell(file);
    printf("seek2\r\n");
    fseek(file, 0L, SEEK_SET);
    
    printf("Size %d\n\r", fileLen);
    
    /*string dst = dstFile;
    string h = ;
    memcpy(header, h.c_str(), sizeof(header));*/
    sprintf(header, "--R50hrfBj5JYyfR3vF3wR96GPCC9Fd2q2pVMERvEaOE3D8LZTgLLbRpNwXek3\r\nContent-Disposition: form-data; name=file; filename=%s\r\nContent-type: application/octet-stream\r\n\r\n", dstFile);
    
    headerSize = strlen(header);
    footerSize = strlen(footer);
    
    totalLen = fileLen + strlen(header) + strlen(footer);
}

HTTPFileSender::~HTTPFileSender()
{
    fclose(file);
    printf("file %d closed\r\n", file);
}

int HTTPFileSender::read(char* buf, int len)
{
    //printf("read requested %d bytes from file %d\n\r", len, file);
    
    int dataSent = 0;

    //printf("Header: %d, Footer: %d\r\n", headerSize, footerSize);

    if (pos >= totalLen)
    {
        printf("End of file\n\r");
        return 0;
    }
    
    if (pos < headerSize)
    {
        int bytesToCopy = headerSize - pos;
        memcpy(buf, header + pos, bytesToCopy);
        
        dataSent += bytesToCopy;
        pos += bytesToCopy;
        
        //printf("transfer header %d\r\n", bytesToCopy);
    }
    
    //printf("Before content: %d %d\r\n", pos, dataSent);
   
    if (pos >= headerSize &&
        pos < (headerSize + fileLen))
    {
        int bytesRead = fread(buf + dataSent, 1, len - dataSent, file);
        
        dataSent += bytesRead;
        pos += bytesRead;
        
       // printf("transfer content %d\r\n", bytesRead);
    }
    
   // printf("Before footer: %d %d\n\r", pos, dataSent);
    
    if (dataSent < len &&
        pos >= (headerSize + fileLen) &&
        pos < (headerSize + fileLen + footerSize))
    {
        int posInFooter = pos - fileLen - headerSize;
        int bytesToCopy = min(footerSize - posInFooter, len - dataSent);
        
        memcpy(buf + dataSent, footer + posInFooter, bytesToCopy);
        
        dataSent += bytesToCopy;
        pos += bytesToCopy;
        
       // printf("transfer footer %d\r\n", bytesToCopy);
    }
    
    //printf("After: %d %d\r\n", pos, dataSent);
    
    //int result = fread(buf, 1, len, file);
    
    //printf("read %s %d bytes\r\n", buf, dataSent);
    if (pos % 1024 == 0) printf("read %d bytes pos %d\r\n", dataSent, pos);
        
    return dataSent;
}

string HTTPFileSender::getDataType()
{
   // printf("data type read\n\r");
    return "multipart/form-data; boundary=R50hrfBj5JYyfR3vF3wR96GPCC9Fd2q2pVMERvEaOE3D8LZTgLLbRpNwXek3";
}

int HTTPFileSender::getDataLen() 
{ 
   // printf("get data len %d\n\r", totalLen);
    return totalLen; 
}

void HTTPFileSender::clear() { }

int HTTPFileSender::write(const char* buf, int len)  { return 0; }
  
void HTTPFileSender::setDataType(const string& type) { } 
  
bool HTTPFileSender::getIsChunked() { return false; }
void HTTPFileSender::setIsChunked(bool chunked) { }
  
void HTTPFileSender::setDataLen(int len)  { }