#include "HttpHandlerSetup.h"

bool ReadSettings(char* username, char* password)
{
    //printf("ReadSettings start\r\n");
    FILE* settingsFile = fopen("/usb/DBSet.txt", "r");
    if (settingsFile)
    {
       printf("before fseek %d\n\r", settingsFile);
       fseek(settingsFile, 9L, SEEK_SET);
       fgets(username, 32, settingsFile);
       fseek(settingsFile, 9L, SEEK_CUR);
       fgets(password, 32, settingsFile);


       int len = strlen(username); username[len - 2] = 0; // remove /r/n
       //printf("ReadSettings %s, %s, %d, %d,  %s\r\n", username, password, len, ftell(settingsFile), data);
       //printf("ReadSettings OK %s, %s\r\n", username, password);
       fclose(settingsFile);
    }
    
    return settingsFile != 0;
}

HttpHandlerSetup::HttpHandlerSetup(const char* rootPath, const char* path, TCPSocket* pTCPSocket) :
 HTTPRequestHandler(rootPath, path, pTCPSocket)
{
  //printf("HttpHandlerSetup()");
}

HttpHandlerSetup::~HttpHandlerSetup()
{
} 

void HttpHandlerSetup::doGetPageWelcome()
{
  //printf("doGetPageWelcome()-start\r\n");
  const char* resp = 
    "<html><body>"
    "<p><span style=\"color: #a9a9a9\"><span style=\"font-size: 12px\">DropBox Sync Setup</span></span></p><p>"
    "<p><a href=\"/Setup\">Setup</a></p>"
    "<p><a href=\"/UsbBrowser/root/\">DiskOnKey browser</a></p>"
    "</form><p>&nbsp;</p>"
    "<p><strong><span style=\"color: #000080\">BDDB Ltd.</span></strong></p>"
    "</body>"
    "</html>";
  
  int len = strlen(resp);
  setContentLen(len);
  respHeaders()["Connection"] = "close";
  writeData(resp, len);
}

void HttpHandlerSetup::UpdateSettingsFile()
{   
  if (m_WasDataRead)
  {
    return;
  }
  
  char buffer[256];
  int dataLength = dataLen();
  int readBytes = readData(buffer, 45 + dataLength);
  
  if (readBytes > 0)
  {  
      //printf("UpdateSettingsFile %s \r\n", buffer);
      int offset = readBytes > dataLength ? 45 : 0; // Inconsistent data reading
      char* c1 = strchr(buffer, '&');
      char* c2 = strchr(buffer + offset, '=') + 1;
      char* c3 = strchr(c1, '=') + 1;
      int lenU = c1 - c2;
      int lenP = readBytes - (c3 - buffer);
      
      char* c2_fixed = strstr(c2, "%40");
      if (c2_fixed) // case @ is replaced by %40
      {
        c2_fixed[0] = '@';
        memcpy(c2_fixed + 1, c2_fixed + 3, lenU - (c2_fixed - c2) - 3);
        lenU -= 2;
        printf(c2);
      }
      
      FILE* settingsFile = fopen("/usb/DBSet.txt", "w");
      if (settingsFile)
      {
         fwrite("USERNAME=", 1, 9, settingsFile);
         fwrite(c2, 1, lenU, settingsFile);
         fwrite("\r\nPASSWORD=", 1, 11, settingsFile);
         fwrite(c3, 1, lenP, settingsFile);
         fclose(settingsFile);
       
         //printf("Updated %s, %s\r\n", c2, c3);
       }
       m_WasDataRead = true;      
   }
   
   //printf("readBytes %d\r\n", readBytes);
}

void HttpHandlerSetup::doGet()
{
  //printf("Setup path %s\r\n", path());
  if (path().size() <= 1)
  {
    doGetPageWelcome();
    return;
  }
  
  //printf("doGet()-start %s, %s\r\n", Username, Password);
  const char* resp1 = 
    "<html><body>"
    "<p><span style=\"color: #a9a9a9\"><span style=\"font-size: 12px\">DropBox Sync Setup</span></span></p><p>"
    "<form method=\"post\" action=\"\">"
    "Username: <input type=\"text\" name=\"Username\" value=\"";
  const char* resp2 = "\" /><br />Password: <input type=\"text\" name=\"Password\" value=\"";
  const char* resp3 = 
    "\" /><br /><input type=\"submit\" value=\"Submit\" />"
    "</form><p>&nbsp;</p>"
    "<p><strong><span style=\"color: #000080\">BDDB Ltd</span></strong></p>"
    "</body>"
    "</html>";

  char username[32]="invalid", password[32]="error";
  ReadSettings(username, password);
  
  int l1 = strlen(resp1), l2 = strlen(resp2), l3 = strlen(resp3);
  int p = strlen(password), u = strlen(username);

  respHeaders()["Connection"] = "close";
  
  setContentLen(l1 + l2 + l3 + p + u);
  int t1 = writeData(resp1, l1);
  int t2 = writeData(username, u);
  int t3 = writeData(resp2, l2);
  int t4 = writeData(password,p);
  int t5 = writeData(resp3, l3);
  
  m_WasDataRead = false;
  printf("doGet()-end\r\n");
}

void HttpHandlerSetup::doPost()
{/*
  map<string,string>::iterator it = reqHeaders().begin();
  printf("printing %s\n\r", path());
  while (it != reqHeaders().end())
  {
    printf("%s --- %s\r\n", it->first, it->second);
    it++;
  }
 */
  printf("doPost()-start\r\n");
  UpdateSettingsFile();
  
  const char* resp = 
    "<html><body>"
    "<p><span style=\"color: #0080FF\"><span style=\"font-size: 14px\">Password changed</span></span></p><p>"
    "<FORM><INPUT TYPE=\"button\" VALUE=\"Back\" onClick=\"history.go(-1);return true;\"></FORM>"
    "</form><p>&nbsp;</p>"
    "<p><strong><span style=\"color: #000080\">BDDB Ltd.</span></strong></p>"
    "</body>"
    "</html>";
  const int length = strlen(resp);
  setContentLen(length);
  respHeaders()["Connection"] = "keep-alive";
  writeData(resp, length);
    
  printf("doPost()-end\r\n");
}

void HttpHandlerSetup::doHead()
{
  printf("onHead\r\n");
}
  
void HttpHandlerSetup::onReadable() //Data has been read
{
  printf("onReadable\r\n");
  UpdateSettingsFile();  
  close();
}

void HttpHandlerSetup::onWriteable() //Data has been written & buf is free
{
//  printf("onWriteable() password: %s, username:%s \r\n", Password, Username);
  printf("onWriteable\r\n");
  close(); //Data written, we can close the connection
}

void HttpHandlerSetup::onClose() //Connection is closing
{
  printf("onClose\r\n");
  //Nothing to do
}
