#include "HTTPData.h"
#include "HTTPClient.h"

// uploads a local file using multipart encoding
class HTTPFileSender : public HTTPData
{
 public:
  HTTPFileSender(const char *fileName, const char* dstFile);  
  virtual ~HTTPFileSender();
  virtual void clear();
  virtual int read(char* buf, int len);
  virtual int write(const char* buf, int len);
  
  virtual string getDataType(); //Internet media type for Content-Type header
  virtual void setDataType(const string& type); //Internet media type from Content-Type header
  
  virtual bool getIsChunked(); //For Transfer-Encoding header
  virtual void setIsChunked(bool chunked); //From Transfer-Encoding header
  
  virtual int getDataLen(); //For Content-Length header
  virtual void setDataLen(int len); //From Content-Length header, or if the transfer is chunked, next chunk length
 private:
    FILE *file; 
    
    int pos;
    int totalLen;
    int fileLen;
    
    int headerSize;
    int footerSize;
    
    static char header[256];
    static char footer[128];
};