#include "Dropbox.h"
#include "HTTPClient.h"
#include "HTTPFileSender.h"
#include "base64.h"
#include "url.h"
#include "ctc_hmac.h"
#include "NTPClient.h"
#include "HTTPData.h"

// NET
NTPClient ntpClient;
HTTPResult result;

// Dropbox
string consumer_token = "p4t8cn8b3ddci2d";
string consumer_token_secret = "wtib99x350qo5l6";
char token[16] = {0};
char token_secret[16] = {0};
volatile bool completed = false;
int v = 6000;
char buffer[1024] = {0};

Timer timer;

extern DigitalOut led1;
extern DigitalOut led3;
extern void USBLoop();

void request_callback(HTTPResult r)
{
  result = r;
  completed = true;
}

bool dropbox_getToken(char* username, char* password)
{
    HTTPText data;
    HTTPClient client;
    
    /* Request Token */ 
    printf("Requesting token\r\n");
    
    char request[128] = {0};
    sprintf(request,
            "http://api.getdropbox.com/0/token?oauth_consumer_key=p4t8cn8b3ddci2d&email=%s&password=%s",
            username,
            password);
    
    printf(request);
    HTTPResult result = client.get(request, &data);
                                   
    if (result != HTTP_OK)
    {
        printf("R: %d", result);
        return false;
    }
    
    const char *dataContent = data.gets();    

    memcpy(token, dataContent + 11, 15); 
    memcpy(token_secret, dataContent + 40, 15); 
    
    printf("Got token %s %s %s\r\n", dataContent, token, token_secret);
    
    return true;
}

bool dropbox_syncTime()
{
    /* Get Time */
    printf("Synchronizing time\r\n");
    Host server(IpAddr(), 123, "0.pool.ntp.org");
    NTPResult result = ntpClient.setTime(server);
    
    //srand(time(NULL));
    
    return (result == NTP_OK);
}

bool dropbox_upload(string srcFile, string dstFile)
{    
    HTTPClient client;
    string dst = dstFile;
    
    time_t currentTime = time(NULL);
      
    v++; //= (rand() % 9999999) + 1000;

    //printf("T: %d NONCE: %d\r\n", currentTime, v); 
    
    memset(buffer, 0x00, 1024);
    sprintf(buffer, 
            "POST&http%%3A%%2F%%2Fapi-content.dropbox.com%%2F0%%2Ffiles%%2Fdropbox%%2F&file%%3D%s%%26oauth_consumer_key%%3D%s%%26oauth_nonce%%3D%d%%26oauth_signature_method%%3DHMAC-SHA1%%26oauth_timestamp%%3D%d%%26oauth_token%%3D%s",
            dst.c_str(),
            consumer_token.c_str(),
            v,
            currentTime,
            token);
   
    //printf("Sig: %s %d\n\r", buffer, strlen(buffer)); 
              
    string key = consumer_token_secret + "&" + token_secret;
    
    //printf("Key: %s %d\n\r", key.c_str(), key.size()); 
    
    byte hash[SHA_DIGEST_SIZE];
    Hmac hmac;
    HmacSetKey(&hmac, SHA, (const byte*)key.c_str(), key.size());
    HmacUpdate(&hmac, (const byte*)buffer, strlen(buffer));
    HmacFinal(&hmac, hash);

    char sig[128] = {0};
    base64enc((char*)hash, SHA_DIGEST_SIZE, sig);

    char *encodedSig = url_encode(sig);
    
    memset(buffer, 0x00, 1024);
    sprintf(buffer, 
            "http://api-content.dropbox.com/0/files/dropbox/?file=%s&oauth_consumer_key=%s&oauth_nonce=%d&oauth_timestamp=%d&oauth_token=%s&oauth_signature_method=HMAC-SHA1&oauth_signature=%s",
            dst.c_str(),
            consumer_token.c_str(),
            v,
            currentTime,
            token,
            encodedSig);
            
    //printf("Req: %s %d\n\r", buffer, strlen(buffer));

    HTTPFileSender httpFile(srcFile.c_str(), dst.c_str());

    HTTPText res;

    //client.setTimeout(5000);
    
    completed = false;
    HTTPResult postResult = client.post(buffer, httpFile, &res, request_callback);
    
    timer.start();
    
    while (!completed)
    {
        led1 = (timer.read_ms() % 250) >= 125;
        USBLoop();
        Net::poll();
    }
    
    timer.stop();
    timer.reset();
    
    led1 = 1;
    
    printf("Res: %s %d %d\n\r", res.gets(), postResult, result);
    
    free(encodedSig);
    
    return (result == HTTP_OK);
}

bool send_email(char* email)
{
    HTTPText txt;
    HTTPClient client;
    //char request[128] = "http://www.davidberlin.co.il/mail.php?pass=borisdavid&email=";    
    //strcpy(request + 60, email);
    char request[128] = "http://holev.com/hello.txt";
    
    //printf(request);
    
    completed = false;
    HTTPResult result2 = client.get(request, &txt, request_callback);
    
    while (!completed)
    {
        Net::poll();
    }
    led1 = 1;
    
    printf("Result %d:\"%s\"\r\n", result, txt.gets());
    
    return result == HTTP_OK;
}