#include "FATFileSystem.h"

int MassStorage_ReadCapacity(int device, u32* blockCount, u32* blockSize);
int MassStorage_Read(int device, u32 blockAddr, u32 blockCount, u8* dst, u32 blockSize);
int MassStorage_Write(int device, u32 blockAddr, u32 blockCount, u8* dst, u32 blockSize);

class USBFileSystem : public FATFileSystem
{
    int _device;
    u32 _blockSize;
    u32 _blockCount;
    
public:
    USBFileSystem() : FATFileSystem("usb"),_device(0),_blockSize(0),_blockCount(0)
    {
    }
    
    void SetDevice(int device)
    {
        _device = device;
    }
    
    virtual int disk_initialize()
    {
        return MassStorage_ReadCapacity(_device,&_blockCount,&_blockSize);
    }
    
    virtual int disk_write(const char *buffer, int block_number)
    {
        return MassStorage_Write(_device,block_number,1,(u8*)buffer,_blockSize);
    }
    
    virtual int disk_read(char *buffer, int block_number)
    {
        //printf("disk_readA\r\n");
        int r = MassStorage_Read(_device,block_number,1,(u8*)buffer,_blockSize);
        //printf("disk_readB\r\n");
        return r;
    }
        
    virtual int disk_sectors()
    {
        return _blockCount;
    }
};
