#include "mbed.h"
#include "BLEPeripheral.h"

//serial connection via USB 
Serial serial(USBTX, USBRX);

//Declare Input and Output pins
DigitalIn pb(D3);
AnalogIn pH_sensor(A0);
InterruptIn button(D2); 
DigitalOut led(LED_RED);

// The SPI construct, REQN and RDYN IO construct should be modified manually
// It depend on the board you are using and the REQN&RDYN configuration on BLE Shield
SPI spi(PTD2, PTD3, PTD1);      
DigitalInOut BLE_RDY(PTD5);  
DigitalInOut BLE_REQ(PTD0); 
DigitalInOut BLE_RESET(PTA13);

//for BLE
int count = 0;
unsigned char txbuf[16] = {0};
unsigned char txlen = 0;

/*----- BLE Utility -------------------------------------------------------------------------*/
// create peripheral instance, see pinouts above
BLEPeripheral            blePeripheral        = BLEPeripheral(&BLE_REQ, &BLE_RDY, NULL);
 
// create service
BLEService               uartService          = BLEService("713d0000503e4c75ba943148f18d941e");
 
// create characteristic
//BLECharacteristic    txCharacteristic = BLECharacteristic("713d0002503e4c75ba943148f18d941e", BLENotify, 20);
BLECharacteristic    rxCharacteristic = BLECharacteristic("713d0003503e4c75ba943148f18d941e", BLENotify, 20);
/*--------------------------------------------------------------------------------------------*/
 
unsigned int interval = 0;
unsigned char count_on = 0;

//for pH measurement
int calib = 0;
int avgReading = 0;
bool calibrationORnot = true;
bool ready = false;
int* reading[] = {0,0};


//This loop takes a reading by taking 15 measurements and averaging them when it is called in the loop "measure"
int takeReading()
{
    double totalVal = 0.0;
    double pH_sensor_read = 0.0;
    int totalReadings = 0;
    while(totalReadings < 16){
        pH_sensor_read = pH_sensor.read();
        totalVal = totalVal + pH_sensor_read;
        totalReadings++;
        }
    int avgSensor = totalVal/15;      
    return avgSensor;
 }

void calibration()
{
    serial.printf("enter calibration loop\n");
    //Loop to take calibration value
    calib = takeReading();
    serial.printf("calib is %d\n", calib);
}

void calculate()
{
    serial.printf("entered calc\n");
    //Take average of readings over 10 seconds        
    avgReading = takeReading();
    serial.printf("took reading\n");
    ready = true;
}

void measure()
{
    serial.baud(115200);
    serial.printf("start measurement");
    //cb.mode(PullUp);
    if(calibrationORnot)
    {
        calibration();
        calibrationORnot = !calibrationORnot;
    }    
//Loop to take measurement        
    else if(!calibrationORnot) 
    {
        serial.printf("enter measurement loop\n");
        serial.printf("calib is %d\n", calib);
        calculate();
    }
}


int main()
{ 
    pb.mode(PullUp);
    serial.baud(115200);
    serial.printf("Hello SmartD!\n");
    serial.printf("Serial begin!\r\n");
    int pH,yint,tempC,tempF;

     /*----- BLE Utility ---------------------------------------------*/
    // set advertised local name and service UUID
    blePeripheral.setLocalName("Sita");
    
    blePeripheral.setAdvertisedServiceUuid(uartService.uuid());
        
    // add service and characteristic
    blePeripheral.addAttribute(uartService);
    blePeripheral.addAttribute(rxCharacteristic);
    //blePeripheral.addAttribute(txCharacteristic);

    // begin initialization
    blePeripheral.begin();
    /*---------------------------------------------------------------*/

    //serial.printf("GOT IT pH is %d, Temp is %d\n\r", reading[0], reading[1]);    
    serial.printf("BLE UART Peripheral begin!\r\n");
    if (calibrationORnot)
    {    
        button.rise(&measure);
    }
    
    while(1)
    {
        //serial.printf("GOT IT pH is %d, Temp is %d\n\r", reading[0], reading[1]);    
        BLECentral central = blePeripheral.central();
        if (ready) 
        {
            //calcuating yintercept of the ADC -> pH equation using calibration value and given that calibration liquid is pH4
            yint = (68.97*calib)-4;
            serial.printf("yint is %f", yint);
            //assumes linear relationship between pin readout -> voltage ->pH
            pH = (0.0209*3300)*(avgReading)-yint;
            //conversion to degrees C from sensor output voltage
            tempC = (((3000*avgReading/1000) - 1.022129)/-0.0018496);
            tempF = (tempC *9/5) + 32;
            //print current pH and temp
            serial.printf("pH = %5.2d & temp = %5.2d F\n\r", pH, tempF);
            ready = !ready;
        }
        if (central) 
        {
            // central connected to peripheral
            serial.printf("Connected to central\r\n");
            while (central.connected()) 
            {
                if (!pb)  // if button pushed
                {
                    serial.printf("pH is %d, Temp is %d\n\r", pH, tempF);
                    // Read and send out pH value from measure function
                    //unsigned int value = pH;
//                    serial.printf("VALUE IS %d\n\r", value);
//                    const unsigned char val[1] = {value};
//                    serial.printf("VALUE AFTER IS %d\n\r", val[1]);
//                    rxCharacteristic.setValue(val,1);
                    unsigned int value2 = tempF;
                    serial.printf("VALUE FIRST IS %d\n\r", value2);
                    const unsigned char val2[1] = {value2};
                    serial.printf("VALUE AFTER IS %d\n\r", val2[1]);
                    rxCharacteristic.setValue(val2,1);

                }
            }
        
            // central disconnected
            serial.printf("Disconnected from central\r\n");
        }
    }
}