
#define i2c_sda D14
#define i2c_scl D15

#define SourceVH 0x58
#define SourceVL 0x59
#define SenseVH 0x54
#define SenseVL 0x55
#define PowerH 0x5B
#define PowerL 0x5C

I2C i2c_PM(i2c_sda, i2c_scl);

class powerMon{
 private:
    int w_addr,r_addr;

 public:
 powerMon(int addr_sel){
    switch(addr_sel)
     {
         case 0: w_addr=0x98; break;
         case 100: w_addr=0x9A; break;
         case 180: w_addr=0x9C; break;
         case 300: w_addr=0x9E; break;
         case 430: w_addr=0x90; break;
         case 560: w_addr=0x92; break;
         case 750: w_addr=0x94; break;
         case 1270: w_addr=0x96; break;
         case 1600: w_addr=0x50; break;
         case 2000: w_addr=0x52; break;
         case 2700: w_addr=0x54; break;
         case 3600: w_addr=0x56; break;
         case 5600: w_addr=0x58; break;
         case 9100: w_addr=0x58; break;
         case 20000: w_addr=0x5A; break;
         case -1: w_addr=0x30; break;
       }  
       r_addr=w_addr+0x01;
         
         }
double V_Sense(){
    double volt=0,mult_fac=1,offset=0;
    char buffer[2];
    buffer[0]=SenseVL;
    i2c_PM.write(r_addr,buffer, 1,true);
    i2c_PM.read(r_addr, buffer,1);
    volt=buffer[0]/16;
    buffer[0]=SenseVH;
    i2c_PM.write(r_addr,buffer, 1,true);
    i2c_PM.read(r_addr, buffer,1);
    volt += (buffer[0] & 0x7f)*16;
    volt = (volt*mult_fac)+offset;
    return (buffer[0]&0x80)?-volt:volt;
}    
double V_Source(){
    double volt=0;
    char buffer[2];
    buffer[0]=SourceVL;
    i2c_PM.write(r_addr,buffer, 1,true);
    i2c_PM.read(r_addr, buffer,1);
    volt=buffer[0]/32;
    buffer[0]=SourceVH;
    i2c_PM.write(r_addr,buffer, 1,true);
    i2c_PM.read(r_addr, buffer,1);
    volt += buffer[0]*8;
    
    return (volt/2048.0000)*23.9883;
}    
double Current(){
    return (V_Sense()/2047.0000)*(8.0000);}
long Power_Ratio(){
    long power_r=0;
    char buffer[2];
    buffer[0]=PowerL;
    i2c_PM.write(r_addr,buffer, 1,true);
    i2c_PM.read(r_addr, buffer,1);
    power_r=buffer[0];
    buffer[0]=PowerH;
    i2c_PM.write(r_addr,buffer, 1,true);
    i2c_PM.read(r_addr, buffer,1);
    power_r += buffer[0]*256;
    
    return power_r;}
double Power(){
   return (Power_Ratio()/65535.0000)*(8.0000*23.9883);
    }

};