#include "mbed.h"
#include "QEI.h"
#include "MFRC522.h"

#define MF_RESET    D8

Serial pc(USBTX, USBRX);

MFRC522    RfChip   (D11, D12, D13, D10, D8);

QEI temp_dial(A3, A4, A1, 50, QEI::X4_ENCODING);
BusIn joy_bus{D3, D4, D5, D6};
BusIn button_bus{D7, D9};
DigitalIn a(D7),b(D9),c(D3),d(D4),e(D5),f(D6); //Dummy pin for pulling


int data[8],RFID_Tag = 0;
unsigned int sum_x = 0;

void init_();
void RFID_Tag_Read();

int main() {
    
    
    uint16_t pulse = 0;
    init_();
    
    while(1){
       //  continue;
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      continue;
    }

    if ( ! RfChip.PICC_ReadCardSerial())
    {
     continue;
    }

    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      sum_x += RfChip.uid.uidByte[i];
      //pc.printf(" %X02", RfChip.uid.uidByte[i]);
    }
    /*pc.printf("\n\r");
    pc.printf(" UID_sum %d", sum_x);
    pc.printf("\n\r");*/
    
    if(sum_x == 461)RFID_Tag = 1;
    else if(sum_x == 538)RFID_Tag = 2;
    else if(sum_x == 598)RFID_Tag = 3;
    else if(sum_x == 548)RFID_Tag = 4;
    else RFID_Tag = 0;
    
     pc.printf("RFID_Tag : %d",RFID_Tag);
     pc.printf("\n\r");
    sum_x = 0;
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    
  // continue;
        
        
        
        
        
        
        
        
        
        
        pulse = temp_dial.getPulses()/2;
        if (pulse >= 350)
            pulse = 350;
        else if (pulse <= 0)
            pulse = 0; 
        data[0] = 0x77;
        data[1] = button_bus.read();
        data[2] = joy_bus.read();
        if (pulse > 255){
            data[3] = pulse-255;
            data[4] = 255;
        }else{ 
            data[3] = 0;
            data[4] = pulse;
        } 
        data[5] = 0x00;
        data[6] = 0x00;
        data[7] = 0x0A;
        
        //Data overwrite for serial transmit debug
       /* data[0]= 0x00;
        data[1]= 0x01;
        data[2]= 0x02;
        data[3]= 0x03;
        data[4]= 0x04;
        data[5]= 0x05;
        data[6]= 0x06;
        data[0]= 0x00;
        */
        
       // for (int i = 0; i<=7; i++)
       //     pc.putc(data[i]);
    }
}


void init_(){
    pc.baud(9600);
    
    RfChip.PCD_Init();
    
    a.mode(PullDown);
    b.mode(PullDown);
    c.mode(PullDown);
    d.mode(PullDown);
    e.mode(PullDown);
    f.mode(PullDown);   
}

void RFID_Tag_Read()
{
   
   
    }