#include "mbed.h"
#include "SPI_TFT_ILI9341.h"
#include "_24LCXXX.h"
#include "beep.h"
//----------------------------------
#include "digi36x44.h"
#include "Consolas26x49.h"
#include "Consolas19x35.h"
#include "Courier8x13.h"
#include "CourierNew13x23.h"
#include "Lucida13x21.h"
//----------------------------------
#define text5 0xFFFF
#define back5 0x018C

#define text5_i 0x0000
#define back5_i 0x0660
#define back5_iset 0xF986
//----------------------------------
#define text4 0xFFFF
#define back4 0x3320

#define text4_i 0x0000
#define back4_i 0xFCD9
//----------------------------------
#define text2 0x0000
#define back2 0x9E7F
//----------------------------------
#define colorline 0xECA7            // цвет рамок    0xECA7 - песочный    0x018C - темносиний    0xFFE0 - желтый
#define color_text_on Green         // ON текст
#define color_back_on 0x0339        // ON фон
#define color_scale1 0x3320           // шкала U
#define color_scale2 0x9A60           // шкала I
//----------------------------------
SPI_TFT_ILI9341 TFT(PB_15, PB_14, PB_13, PB_12, PC_7, PC_6,"TFT"); // mosi, miso, sclk, cs, reset, dc
void grid(void);
Timer fps;// FPS
Timeout timerforfanstart; //таймер для запуска мотора
Timeout timerforpoweriddle; //таймер для паузы срабатывания кнопки
Timeout iddletimesaver;    // таймер времени до включения заставки
int fst=0;
int fst2=0;
//Ticker valueUI;
InterruptIn button(PB_9); // кнопка питания вкл\выкл
Beep buzzer(PB_3);        // звук
//I2C i2c(PC_9, PA_8);            // sda, scl для флэш памяти для f401 
I2C i2c(PB_11, PB_10);          // sda, scl для флэш памяти для f103
_24LCXXX eeprom(&i2c, 0x50);
//----------------------------------------------------------------------------------------------------------- Ввести в меню опцию коррекции падения напряжения на токоизмерительном шунте.
int t;        // секунд с момента включения
int tstart;   // при включении нагрузки равна реальному времени
time_t treal; // секунды реального времени для таймера нагрузки
int h=0;      //вывод часов
int m=0;     // минут
int s=0;     // секунд
void timeConvert(void);
//----------- my functions ---------//
void drawScreen1(void);             // экран 1  Главный экран
void drawScreen2(void);             // экран 2  dats analog in and Noise
void drawScreen3(void);             // экран 3
void drawScreen4(void);             // экран 4  Калибровка
void drawScreen5(void);             // экран 5  Настройки главный
void drawScreen6(void);             // экран 6
void drawScreen7(void);             // экран 7
void drawScreen8(void);             // экран 8
void bootCold(void);                // холодный старт
void loaddefaultsettings(void);     // загрузка настроек по умолчанию
void loadsettings(void);            // загрузка настроек при старте
void savedefaulttoflash(void);      // сохранить в флэш настройки по умолчанию (для активации работы флэш)
void fans(void);                    // управление вентиляторами
void fanstart(void);                // первичный старт вентилятора
void keypoweriddle(void);           // для задержка опроса кнопки питания
void ScreenSaver(void);            // ScreenSaver
void screensaverstart(void);       // старт заставки
void bootscreen(void);             // экран при старте
int saveractive=0;
int onesaver=0;
int onepower=0;                      // для задержка опроса кнопки питания
//-----------------
void Protect(void);                  // функция обработки защиты
int shl=0;
int shm=0;
int shortline=0;
//-----------------
float map(float, float, float, float, float);   // масштабирование
void SetDateTime(void);             // установка даты и времени
int year=2014;
int mon=11;
int day=1;
int hour=16;
int min=42;
int sec=0;
time_t seconds;     //для часов реального времени
int tempstart=42;   //             температура старта вентилятора
int tempfull=60;    //             полной мощности вентилятора  tempstart tempfull tempcutoff
int tempcutoff=80;  //             отключения нагрузки
int umax=31;          // U max, Volt
float imax=2.6;       // I max, Amper
float rdown=0.05;    // R сопротивление шунта для расчета падения напряжения выхода от зависимости от тока нагрузки
int rdown_on=1;       // по умолчанию без падения напряжения на резисторе шунта
char *ron = "On ";     // для вывода в меню главных настроек On
char *roff = "Off";    // для вывода в меню главных настроек Off
//---------------------------
float avgAin0();                    // среднее значение с входа A0
float avgAin1();                    // среднее значение с входа A1
float avgAin2();                    // среднее значение с входа A2
float avgAin3();                    // среднее значение с входа A3
//----
float in0 = 0;
float in1 = 0;
float in2 = 0;
float in3 = 0;
//----
float U5 = 0;
float Ireal = 0;
float U30 = 0;
//---------------------------
void dataProcessing(void);          // обработка и подготовка данных с аналоговых входов
void powerButton(void);             // при нажатии кнопки питания
void buttonUse(void);               // обработка нажатий кнопок
//-----------------------------------------------------------------------------------------------------------
float a0a = 0.000679;      // A0 - U 5 - avg при 0 - нижняя точка          U  5 вольт
float a0k = 5.006402;        // A0 - U 5 - коэффициент - верхняя точка
//---------------------------------------------------------------
float a1a = 0.143353;   // A1 - I бп - avg при 0   - нижняя  точка    a1a = avgAin1() - 0.00004
float a1k = 3.224676;       // A1 - I бп - коэффициент - верхняя точка    a1k = 2000/(avgAin1() - a1a) при 2амперах
//---------------------------------------------------------------
float a2a = 0.000015;   // A2 - U 30 - avg при 0   - нижняя  точка         U  33 вольта
float a2k = 33.627953;          // A2 - U 30 - коэффициент - верхняя точка
//---------------------------------------------------------------
float noisea0; //типа уровень шума (разница между минимум и максимум за 100 измерений) для А0
float noisea1; // - - для A1
float noisea2; // - - для A2
float noisea3; // - - для A3
//-----------------------------------------------------------------------------------------------------------
DigitalIn buttonUp(PB_8);     // Up
DigitalIn buttonDown(PB_6);   // Down
DigitalIn buttonEnter(PB_7);  // Enter
int Screen=1;               // по умолчанию грузим первое меню
int complit=0;              // в начале меню не прорисовано
int pb=0;                   // для прорисовки кнопки
int kline=15;                // номер начальной строки в меню калибровки экран 4
int mline=15;                // номер начальной строки в меню Настройки главная экран 5
int mline2=0;               //в главном меню строка 2 не выбрана
int mline4=0;               //                      4
int mline5=0;               //                      5
int mline6=0;               //                      6
int mline7=0;               //                      7
int mline8=0;               //                      8
int mline11=0;               //                     11
int mline12=0;               //                     12
int mline13=0;               //                     13
int mline14=0;               //                     14
int nline=8;               // номер начальной строки в меню установки времени экран 3
int pmenu=0;                //в главном меню изменение выбраной строки не действительно
int powerProtect=1; //защита от кз
int pp=0;           //защита от кз для прорисовки меню
//int cc=0;               // значит идет C.V
int pm=0;               // для одной прорисовки сс и сv
int cs=0;               // короткое замыкание
int csp=0;              // для одной прорисовки короткого замыкания
float brightness = 1.0f; //яркость экрана
PwmOut pinbrightness(PB_5);    // выход на ключ регулировки яркости экрана
float fanspeed = 0.0f;
PwmOut fan(PB_4);              // выход вентилятора
//PwmOut fan2(PA_15);
//float fanspeed2 = 0.8f;
int temperature = 25;        // текущая температура
int screensaver=0;           // заставка 0 - нет, 1 - часы, 2- ...
int beeper=0;                //бипер выключен
//-----------------------------------------------------------------------------------------------------------
DigitalOut powerMosfet(PC_11);         // выход управления нагрузкой
DigitalIn cc(PC_10); //вход СС    0 - СС, 1 - CV
int ccc=0;
DigitalOut ledcc(PD_2);       // светодиод C.C
DigitalOut ledshort(PC_12);   // светодиод КЗ
AnalogIn  ainA0(PA_2);
AnalogIn  ainA1(PA_3);
AnalogIn  ainA2(PA_1);
AnalogIn  ainA3(PA_0);
//AnalogIn  ainA4(A4);
//AnalogIn  ainA5(A5);
//BusOut unused(A4,A5);
//-------------для screen7--
int iiii=0;
//--------------------------
//------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void loaddefaultsettings(void)
{
    a0a = 0.000679;
    a0k = 5.006402;
    a1a = 0.143353;
    a1k = 3.224676;
    a2a = 0.000015;
    a2k = 33.627953;
    imax=2.6;
    rdown=0.05;
    brightness = 1.0f;
    beeper = 0;
    rdown_on=1;
    umax=31;
    tempstart=42;
    tempfull=60;
    tempcutoff=80;
    screensaver=0; 
    ledcc=1;
    wait(0.5);
    ledcc=0;
    wait(0.5);
}
//------------------------------------------------------------------------------------------------------------
void loadsettings(void)
{
    int s;
    int s1;
    eeprom.nbyte_read(0, (char*)&s, sizeof(s));
    eeprom.nbyte_read(4, (char*)&s1, sizeof(s1));
    if (s==0 && s1==1) {       //если флэш активирована то грузим с неё
        ledshort=1;     // 1 раз моргнуло - начало загрузки
        wait(0.02);
        ledshort=0;

        eeprom.nbyte_read(8, (char*)&a0a, sizeof(a0a));    // a0a float - 4 байта
        eeprom.nbyte_read(12, (char*)&a0k, sizeof(a0k));    // a0k float - 4 байта
        eeprom.nbyte_read(16, (char*)&a1a, sizeof(a1a));   // a1a float - 4 байта
        eeprom.nbyte_read(20, (char*)&a1k, sizeof(a1k));   // a1k float - 4 байта
        eeprom.nbyte_read(24, (char*)&a2a, sizeof(a2a));   // a2a float - 4 байта
        eeprom.nbyte_read(28, (char*)&a2k, sizeof(a2k));   // a2k float - 4 байта

        eeprom.nbyte_read(32, (char*)&imax, sizeof(imax));             // imax float - 4 байта
        eeprom.nbyte_read(36, (char*)&rdown, sizeof(rdown));           // rdown float - 4 байта
        eeprom.nbyte_read(40, (char*)&brightness, sizeof(brightness)); // brightness float - 4 байта
        eeprom.nbyte_read(44, (char*)&beeper, sizeof(beeper));     // beeper float - 4 байта

        eeprom.nbyte_read(48, (char*)&rdown_on, sizeof(rdown_on));    // rdown_on float - 4 байт
        eeprom.nbyte_read(52, (char*)&umax, sizeof(umax));        // umax float - 4 байт
        eeprom.nbyte_read(56, (char*)&tempstart, sizeof(tempstart));   // tempstart float - 4 байт
        eeprom.nbyte_read(60, (char*)&tempfull, sizeof(tempfull));    // tempfull float - 4 байт
        eeprom.nbyte_read(64, (char*)&tempcutoff, sizeof(tempcutoff));  // tempcutoff float - 4 байт
        eeprom.nbyte_read(68, (char*)&screensaver, sizeof(screensaver));  // screensaver float - 4 байт

        wait(0.05); // 2 раза моргнуло удачно загрузили
        ledshort=1;
        wait(0.02);
        ledshort=0;
    }else{
        TFT.foreground(Red);
        TFT.printf("ERROR - flash memory is not activated\n");
        TFT.foreground(White);
        wait(5);
        TFT.printf("Load default settings.");
        for (int i=0; i<10; i++)
        {
        wait(0.1);
        TFT.printf(".");
        }
        TFT.printf("\n");
        loaddefaultsettings();
    }
}
//------------------------------------------------------------------------------------------------------------
void savedefaulttoflash(void)
{

    a0a = 0.000679;
    a0k = 5.006402;
    a1a = 0.143353;
    a1k = 3.224676;
    a2a = 0.000015;
    a2k = 33.627953;
    imax=2.6;
    rdown=0.05;
    brightness = 1.0f;
    beeper = 0;
    rdown_on=1;
    umax=31;
    tempstart=42;
    tempfull=60;
    tempcutoff=80;
    screensaver=0;


    ledshort=1;  // 1 раз моргнуло - начало записи
    wait(0.02);
    ledshort=0;
    wait(0.05);

    int s=0;
    int s1=1;
    eeprom.nbyte_write(0, (char*)&s, sizeof(s));
    eeprom.nbyte_write(4, (char*)&s1, sizeof(s1));

    eeprom.nbyte_write(8, (char*)&a0a, sizeof(a0a));    // a0a float - 4 байта
    eeprom.nbyte_write(12, (char*)&a0k, sizeof(a0k));    // a0k float - 4 байта
    eeprom.nbyte_write(16, (char*)&a1a, sizeof(a1a));   // a1a float - 4 байта
    eeprom.nbyte_write(20, (char*)&a1k, sizeof(a1k));   // a1k float - 4 байта
    eeprom.nbyte_write(24, (char*)&a2a, sizeof(a2a));   // a2a float - 4 байта
    eeprom.nbyte_write(28, (char*)&a2k, sizeof(a2k));   // a2k float - 4 байта

    eeprom.nbyte_write(32, (char*)&imax, sizeof(imax));             // imax float - 4 байта
    eeprom.nbyte_write(36, (char*)&rdown, sizeof(rdown));           // rdown float - 4 байта
    eeprom.nbyte_write(40, (char*)&brightness, sizeof(brightness)); // brightness float - 4 байта
    eeprom.nbyte_write(44, (char*)&beeper, sizeof(beeper));     // beeper float - 4 байта

    eeprom.nbyte_write(48, (char*)&rdown_on, sizeof(rdown_on));    // rdown_on float - 4 байта
    eeprom.nbyte_write(52, (char*)&umax, sizeof(umax));        // umax float - 4 байта
    eeprom.nbyte_write(56, (char*)&tempstart, sizeof(tempstart));   // tempstart float - 4 байта
    eeprom.nbyte_write(60, (char*)&tempfull, sizeof(tempfull));    // tempfull float - 4 байта
    eeprom.nbyte_write(64, (char*)&tempcutoff, sizeof(tempcutoff));  // tempcutoff float - 4 байта
    eeprom.nbyte_write(68, (char*)&screensaver, sizeof(screensaver));  // screensaver float - 4 байта

    int l;
    int l1;
    eeprom.nbyte_read(0, (char*)&l, sizeof(l));
    eeprom.nbyte_read(4, (char*)&l1, sizeof(l1));

    if (l==s && l1==s1) {  //удачно сохранилось - 2 раза моргнуло
        ledshort=1;
        wait(0.02);
        ledshort=0;
    } else {
        ledshort=1;
        TFT.background(Black);
        TFT.foreground(Red);
        TFT.set_font((unsigned char*) Consolas19x35);
        TFT.locate(10, 100);
        TFT.printf("SAVE ERROR");
        wait(5);
        ledshort=0;
    }
}
//------------------------------------------------------------------------------------------------------------
void bootCold(void)
{
    i2c.frequency(100000);
    powerMosfet = 0;                    // при включении выход выключен
    ledcc=0;
    ledshort=0;
    TFT.claim(stdout);
    //set_time(1414838392);  // Set RTC time to Wed, 28 Oct 2009 11:35:37
    tstart = treal = time(NULL);
    pinbrightness.period(0.01);      // задаём частоту Шим подсветки 0.001 - 1000 герц
    fan.period(0.01);
    //fan2.period(0.01);
    TFT.set_orientation(3);
    TFT.background(Black);
    TFT.cls();
    wait(0.2);
    fan = fanspeed; // устанавливаем скорость
    //fan2=fanspeed2;
}
//------------------------------------------------------------------------------------------------------------
void bootscreen(void)
{
    TFT.background(Black);
    TFT.foreground(Green);
    TFT.locate(100, 10);
    TFT.set_font((unsigned char*) Consolas26x49);
    TFT.printf("PSTFT\n");
    TFT.foreground(White);
    TFT.set_font((unsigned char*) CourierNew13x23);
    TFT.printf("      Firmware v. 1.0.0\n");
    TFT.set_font((unsigned char*) Courier8x13);
    TFT.printf(" Laboratory power supply based on STM32\n");
    TFT.printf("       Copyright (c) 2015 Pimenov V\n");
    TFT.printf("          Mail:  sinrab@gmail.com \n");
    pinbrightness = brightness;          // включаем подсветку
    wait(3);
    TFT.locate(0, 150);
    TFT.set_font((unsigned char*) Courier8x13);
    TFT.printf("Press button ENTER\n");
    TFT.printf("for load default settings\n");
    TFT.printf("\n");
    wait(1);  
    if (buttonEnter==0) {
      TFT.printf("Load default settings.");
      for (int i=0; i<10; i++)
      {
      wait(0.1);
      TFT.printf(".");
      }
      TFT.printf("\n");
      loaddefaultsettings();
    }else{
      TFT.printf("Load settings from flash memory.");
      for (int i=0; i<9; i++)
      {
      wait(0.1);
      TFT.printf(".");
      }
      TFT.printf("\n");
      loadsettings();  
    }
    //wait(100);
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
int main()                                                             //--------- Главная функция ---------//
{
    bootCold();                         // холодный старт
    bootscreen();
    button.fall(&powerButton);          // прерывание кнопки включения нагрузки запускает функцию

    while(1) {

        dataProcessing();                   // обработка и подготовка данных с аналоговых входов
        fans();
        Protect();
        if (saveractive==0) {
            buttonUse();                 // обработка нажатий кнопок
        }
        ScreenSaver();                      // заставка
        if (Screen == 1) drawScreen1();
        if (Screen == 2) drawScreen2();
        if (Screen == 3) drawScreen3();
        if (Screen == 4) drawScreen4();
        if (Screen == 5) drawScreen5();
        if (Screen == 6) drawScreen6();
        if (Screen == 7) drawScreen7();
        if (Screen == 8) drawScreen8();

    }
}                                                                      //--------- Главная функция ---------//
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------
void drawScreen1(void)                                                                              // экран 1
{
    if (complit==0) {
        pm=0;
        ccc=0;
        pb=0;
        pp=0;
        csp=0;
        TFT.set_orientation(3);
        TFT.background(Black);
        TFT.cls();
        TFT.rect(0,0,319,239,colorline);     //рамка
        TFT.rect(10,62,309,76,colorline);    //аналоговая рамка 1
        TFT.rect(10,137,309,151,colorline);  //авалоговая рамка 2
        //grid();
        //int y = 51;
        //TFT.line(5,y,310,y, White);
        TFT.background(Black);
        TFT.foreground(colorline);                         // цвет слов
        TFT.set_font((unsigned char*) Consolas26x49);
        TFT.locate(193, 13);
        TFT.printf("v");                                // V
        TFT.locate(165, 88);
        TFT.printf("ma");                               // mA
        complit = 1;  // прорисовали!

        TFT.fillrect(7,161,104,183,0x2104); // подвал левый квадрат верхний заливка
        TFT.fillrect(7,185,104,207,0x2104); //                      средний
        TFT.fillrect(7,207,104,231,0x2104); //                      нижний

        TFT.rect(6,160,105,232,colorline);       // левый квадрат
        TFT.line(7,184,104,184,colorline);      // левый разделительная линия вверхняя
        TFT.line(7,208,104,208,colorline);      //                            нижняя
        TFT.rect(112,160,207,192,colorline);      //средний квадрат верх
        TFT.rect(112,198,207,232,colorline);      //                низ
        TFT.rect(214,160,313,232,colorline);      //правый квадрат

    }
//-----------------------------------------------------------------------------
    if (powerProtect==0 & pp==0) {                                        // защита от кз
        TFT.fillrect(113,161,206,191,Black);           //0
        TFT.background(Black);
        TFT.foreground(0x4208);
        TFT.set_font((unsigned char*) Lucida13x21);
        TFT.locate(115, 165);
        TFT.printf("Protect");
        pp=1;
    }
    if (powerProtect==1 & pp==0) {                     //1
        TFT.fillrect(113,161,206,191,0x0180);
        TFT.background(0x0180);
        TFT.foreground(Green);
        TFT.set_font((unsigned char*) Lucida13x21);
        TFT.locate(115, 165);
        TFT.printf("Protect");
        pp=1;
    }

    if (cs==0 & csp==0) {                                         // прорисовка короткого замыкания TFT.rect(112,198,207,232,colorline);
        TFT.fillrect(113,199,206,231,Black);               //0
        TFT.background(Black);
        TFT.foreground(0x4208);
        TFT.set_font((unsigned char*) Lucida13x21);
        TFT.locate(130, 205);
        TFT.printf("SHORT");
        csp=1;
    }
    if (cs==1 & csp==0) {                                    //1
        TFT.fillrect(113,199,206,231,0x6000);
        TFT.background(0x6000);
        TFT.foreground(Red);
        TFT.set_font((unsigned char*) Lucida13x21);
        TFT.locate(130, 205);
        TFT.printf("SHORT");
        csp=1;
    }



    //fps.reset(); //мерить фпс
    //fps.start();

    TFT.background(Black);

    if (cc==0) {                                            //если C.C то меняем цвет значения напряжения
        TFT.foreground(Red);
    } else {
        TFT.foreground(Green);
    }

    TFT.set_font((unsigned char*) digi36x44);
    TFT.locate(10, 10);
    if(U5<0) U5=0;
    if (U5<4.5f) {
        //TFT.fillrect(10,10,46,54,Black);
        TFT.locate(10, 10);
        TFT.printf("%5.3f", U5);                           // выводим значение с A0 (напряжение)
    } else {
        TFT.locate(10, 10);
        TFT.printf("%05.2f", U30);                         // выводим значение с A0 (напряжение)
    }

    TFT.pixel(82, 53, Black);
    TFT.pixel(117, 53, Black);

    TFT.locate(10, 85);
    TFT.foreground(Green);
    TFT.printf("%04.0f", Ireal);                                   // выводим значение с A1 (ток)


    TFT.background(0x2104);                                         // выводим мощность W
    TFT.foreground(0xE71C);//текст
    TFT.set_font((unsigned char*) Lucida13x21);
    TFT.locate(11, 162);
    TFT.printf("%05.2f W", U30*Ireal/1000);
    //TFT.printf("%f", fanspeed*100);

    TFT.background(0x2104);                                       // выводим время включеной нагрузки
    TFT.foreground(0xE71C);//текст
    TFT.set_font((unsigned char*) Lucida13x21);
    TFT.locate(7, 187);
    timeConvert();
    TFT.printf("%02d:%02d:%02d", h, m, s);


    if (powerMosfet==0 & pb==0) {                                       // выводим OFF
        TFT.background(Black);
        TFT.foreground(0xA514);
        TFT.fillrect(215,161,312,231,Black);
        TFT.set_font((unsigned char*) Consolas26x49);
        TFT.locate(227, 174);
        TFT.printf("OFF");
        pb=1;
    }
    if (powerMosfet==1 & pb==0) {                                      // выводим ON
        TFT.background(color_back_on);
        TFT.foreground(color_text_on);
        TFT.fillrect(215,161,312,231,color_back_on);
        TFT.set_font((unsigned char*) Consolas26x49);
        TFT.locate(238, 174);
        TFT.printf("ON");
        pb=1;
    }

    int xscale1 = map(U30, 0, umax, 0, 298);
    if (xscale1>297) xscale1=298;
    TFT.fillrect(11, 63, (xscale1+10), 75, color_scale1);  //0x04C9                          // аналоговая шкала Напряжение
    TFT.fillrect((xscale1+12), 63, 308, 75, Black);

    int xscale2 = map(Ireal, 0, imax*1000, 0, 298);
    if (xscale2>297) xscale2=298;
    TFT.fillrect(11, 138, (xscale2+10), 150, color_scale2);  //0x9A60                            // аналоговая шкала Ток
    TFT.fillrect((xscale2+11), 138, 308, 150, Black);

    //int zxc = int(Iset);
    //if (zxc>295) zxc=295;
    //if (zxc<0) zxc=0;
    //TFT.fillrect(11+zxc,138, 13+zxc, 150, Red);                                // шкала I set

    //fps.stop();
    //TFT.set_font((unsigned char*) Courier8x13);                                   // FPS
    //TFT.locate(169,81);
    //printf("%0.2f", (1/fps.read()));

    TFT.background(0x2104);
    TFT.foreground(White);
    TFT.set_font((unsigned char*) Lucida13x21);                    //выводим Температуру
    TFT.locate(11, 211);
    TFT.printf("  %d 'C ", temperature);

    /*
    if (dinCC==1 & cc_one==1){
        cc=1;
        pm=0;
        cc_one=0;
        }
    if (dinCC==0 & cc_one==0){
        cc=0;
        pm=0;
        cc_one=1;
        }
        */
    if(cc==1 & ccc==1) {  // защелка для отображения сс сv
        pm=0;
        ccc=0;
    }
    if(cc==0 & ccc==0) {
        pm=0;
        ccc=1;
    }

    if(cc==0 & pm==0) {                                                            // c.c
        TFT.fillrect(240,10,304,53,Black);//c.v стереть
        TFT.fillrect(240,85,304,128,0x6000);//c.c
        TFT.rect(240,85,304,128,0xC800);
        TFT.background(0x6000);
        TFT.foreground(Red);
        TFT.set_font((unsigned char*) Consolas19x35);
        TFT.locate(246, 89);
        TFT.printf("C.C");
        pm=1;
    }
    if(cc==1 & pm==0) {                                                            // c.v
        TFT.fillrect(240,85,304,128,Black);//c.c стереть
        TFT.fillrect(240,10,304,53,0x0180);//c.v
        TFT.rect(240,10,304,53,0x04C0);
        TFT.background(0x0180);
        TFT.foreground(Green);
        TFT.set_font((unsigned char*) Consolas19x35);
        TFT.locate(246, 14);
        TFT.printf("C.V");
        pm=1;
    }


}
//------------------------------------------------------------------------------------------------------------
void drawScreen2(void)                                                                              // экран 2 Data analo in, noise
{
    if (complit==0) {
        TFT.background(back2);
        TFT.foreground(text2);
        TFT.cls();
        complit = 1;  // прорисовали!
    }

    TFT.background(back2);
    TFT.foreground(text2);
    TFT.set_font((unsigned char*) Courier8x13);
    TFT.locate(0, 0);
    printf("--------- Data Analog In --------- \n");
    printf("U.5 A0 noise= %0.1f, avg= %0.5f \n", noisea0, in0);
    printf("U= %06.4f \n coeff. k=%f, a=%f \n", U5, a0k, a0a);    // A0  U real
    printf("---------------------------------- \n");
    printf("I.real A1 noise= %0.1f, avg= %0.5f \n", noisea1, in1);
    printf("I= %06.2f \n coeff. k=%f, a=%f \n", Ireal, a1k, a1a);    // A1  I real
    printf("---------------------------------- \n");
    printf("U.30 A2 noise= %0.1f, avg= %0.5f \n", noisea2, in2);
    printf("U= %06.3f \n coeff. k=%f, a=%f \n", U30, a2k, a2a);     // A2  U set
    printf("---------------------------------- \n");
    printf("Temp A3 noise= %0.1f, avg= %0.5f \n", noisea3, in3);
}
//------------------------------------------------------------------------------------------------------------
void drawScreen3(void)                                                                              // экран 3 установка часов
{
    if (complit==0) {
        TFT.background(back5);
        TFT.foreground(text5);
        TFT.cls();
        complit = 1;  // прорисовали!
    }
    TFT.background(back5);
    TFT.foreground(text5);
    TFT.set_font((unsigned char*) Lucida13x21);
    char buffer[32];
    seconds=time(NULL);
    strftime(buffer, 32, "%H:%M:%S %d.%m.%Y", localtime(&seconds));
    TFT.locate (0,0);
    printf("------- Set Time --------\n");
    TFT.background(back5_i);
    TFT.foreground(text5_i);
    TFT.locate (30,25);
    printf("%s", buffer);    //вывод реального времени
    TFT.background(back5);
    TFT.foreground(text5);
    TFT.locate (28,86);
    printf("%02d:%02d:%02d %02d.%02d.%04d",hour, min, sec, day, mon, year); //вывод то что установим
    //-----------------------------------1
    if (nline==1) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
        TFT.locate(28,64);
        printf("  ");
    } else {
        TFT.locate(28,64);
        TFT.background(back5);
        TFT.foreground(back5);
        printf("  ");
    }
    //-----------------------------------2
    if (nline==2) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
        TFT.locate(64,64);
        printf("  ");
    } else {
        TFT.locate(64,64);
        TFT.background(back5);
        TFT.foreground(back5);
        printf("  ");
    }
    //-----------------------------------3
    if (nline==3) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
        TFT.locate(100,64);
        printf("  ");
    } else {
        TFT.locate(100,64);
        TFT.background(back5);
        TFT.foreground(back5);
        printf("  ");
    }
    //-----------------------------------4
    if (nline==4) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
        TFT.locate(135,64);
        printf("  ");
    } else {
        TFT.locate(135,64);
        TFT.background(back5);
        TFT.foreground(back5);
        printf("  ");
    }
    //-----------------------------------5
    if (nline==5) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
        TFT.locate(170,64);
        printf("  ");
    } else {
        TFT.locate(170,64);
        TFT.background(back5);
        TFT.foreground(back5);
        printf("  ");
    }
    //-----------------------------------6
    if (nline==6) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
        TFT.locate(205,64);
        printf("     ");
    } else {
        TFT.locate(205,64);
        TFT.background(back5);
        TFT.foreground(back5);
        printf("     ");
    }
    //-----------------------------------7
    if (nline==7) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
        TFT.locate(30,120);
        printf("Set!");
    } else {
        TFT.locate(30,120);
        TFT.background(back5);
        TFT.foreground(text5);
        printf("Set!");
    }
    //-----------------------------------
    //-----------------------------------7
    if (nline==8) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(0xFB2C);
            TFT.foreground(text5_i);
        }
        TFT.locate(30,170);
        printf("Exit");
    } else {
        TFT.locate(30,170);
        TFT.background(back5);
        TFT.foreground(text5);
        printf("Exit");
    }
    //-----------------------------------

}
//------------------------------------------------------------------------------------------------------------
void drawScreen4(void)                                                                              // экран 4 калибровка
{
    if (complit==0) {
        TFT.background(back4);
        TFT.foreground(text4);
        TFT.cls();
        complit = 1;  // прорисовали!
    }
    //---------------------------------------------------------------- text4 back4 text4_i back4_i
    TFT.background(back4);
    TFT.foreground(text4);
    TFT.locate(0, 0);
    TFT.set_font((unsigned char*) Courier8x13);
    printf(" Calibration. Enter - set. \n");
    printf("--------------------------- \n");
    //----------------------------------------------------------------
    if (kline==1) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    printf(" U 5v = %06.3f set zero   \n", U5);                // U real A0 zero
    //----------------------------------------------------------------
    if (kline==2) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    printf(" U 5v = %06.3f set up     \n", U5);               // U real A0 hi
    //----------------------------------------------------------------
    if (kline==3) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    printf(" I real = %06.1f set zero   \n", Ireal);                // I real A1 zero
    //----------------------------------------------------------------
    if (kline==4) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    printf(" I real = %06.1f set up     \n", Ireal);                  // I real A1 hi
    //----------------------------------------------------------------
    if (kline==5) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    printf(" U high v =  %06.3f set zero\n", U30);                    // U set  A2 zero
    //----------------------------------------------------------------
    if (kline==6) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    printf(" U high v =  %06.3f set up  \n", U30);                   // U set  A2 hi
    //----------------------------------------------------------------
    if (kline==7) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    printf(" -\n");                 // I set  A3 zero
    //----------------------------------------------------------------
    if (kline==8) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    printf(" -\n");                  // I set  A3 hi
    //----------------------------------------------------------------
    if (kline==9) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    printf(" -\n");                  // U usb A4 zero
    //----------------------------------------------------------------
    if (kline==10) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    printf(" -.\n");                  // U usb A4 hi
    //----------------------------------------------------------------
    if (kline==11) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    printf(" -,\n");                  // I usb A5 zero
    //----------------------------------------------------------------
    if (kline==12) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    printf(" -\n");                 // I usb A5 hi
    //----------------------------------------------------------------
    if (kline==13) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    //printf(" Load Default                \n");
    printf(" Load Default calibration    \n");
    //----------------------------------------------------------------
    if (kline==14) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    //printf(" Save all to flash memory   \n");
    printf(" Save calibration to flash memory\n");
    //----------------------------------------------------------------
    if (kline==15) {
        TFT.background(back4_i);
        TFT.foreground(text4_i);
    } else {
        TFT.background(back4);
        TFT.foreground(text4);
    }
    printf(" Exit                         \n");
    //----------------------------------------------------------------
    TFT.background(back4);
    TFT.foreground(text4);
    printf("--------------------------- \n");


}
//------------------------------------------------------------------------------------------------------------
void drawScreen5(void)                                                                   //экран 5 Настройки главная
{
    if (complit==0) {
        TFT.background(back5);
        TFT.foreground(text5);
        TFT.cls();
        complit = 1;  // прорисовали!
    }

    //----------------------------------------------------------------
    TFT.background(back5);
    TFT.foreground(text5);
    TFT.locate(0, 0);
    TFT.set_font((unsigned char*) Courier8x13);
    printf("                 Settings               \n");
    printf("--------------------------------------- \n");
    //----------------------------------------------------------------
    if (mline==1) {
        TFT.background(back5_i);
        TFT.foreground(text5_i);
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    printf(" Set Time                                   \n");                // 1
    //----------------------------------------------------------------
    if (mline==2) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    printf(" Backlight brightness =              %03.0f \n", brightness*100);                // 1
    //------------------------------------*---------------------------
    if (mline==3) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    if (beeper==1) {
        printf(" Sound beep                            %s \n", ron);
    } else {
        printf(" Sound beep                            %s \n", roff);
    }
    //------------------------------------*---------------------------
    if (mline==4) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    printf(" Fan start - t                      %02d 'c \n", tempstart);                // 1 tempstart
    //------------------------------------*---------------------------
    if (mline==5) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    printf(" Fan full speed - t                 %02d 'c \n", tempfull);                // 1 tempfull
    //------------------------------------*---------------------------
    if (mline==6) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    printf(" Power cut off - t                  %02d 'c \n", tempcutoff);                // 1 tempcutoff
    //------------------------------------*---------------------------
    if (mline==7) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    if (rdown_on==1) {
        printf(" Voltmeter adjustment on R           %s \n", ron);           // падение на R вкл выкл
    } else {
        printf(" Voltmeter adjustment on R           %s \n", roff);
    }
    //------------------------------------*---------------------------
    if (mline==8) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    printf(" Current sense shunt,        R = %05.3f om\n", rdown);                // значения сопротивления шунта
    //------- -----------------------------*---------------------------
    if (mline==9) {
        TFT.background(back5_i);
        TFT.foreground(text5_i);
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    printf(" Calibration I, U                          \n");                // 1
    //------------------------------------*---------------------------
    if (mline==10) {
        TFT.background(back5_i);
        TFT.foreground(text5_i);
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    printf(" Data analog in, noise                    \n");                // 1
    //------------------------------------*---------------------------
    if (mline==11) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    printf(" U max                                 %02.0d V \n", umax);                // U max
    //------------------------------------*---------------------------
    if (mline==12) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    printf(" I max                                %03.1f A \n", imax);                // I max
    //------------------------------------*---------------------------
    if (mline==13) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    printf(" Screen saver                            %d \n", screensaver);                // Screen saver
    //------------------------------------*---------------------------
    if (mline==14) {
        if (pmenu==1) {
            TFT.background(back5_iset);
            TFT.foreground(text5_i);
        } else {
            TFT.background(back5_i);
            TFT.foreground(text5_i);
        }
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    printf(" Load default settings and save to flash\n");                // 1
    //------------------------------------*---------------------------
    if (mline==15) {
        TFT.background(0xFB2C);
        TFT.foreground(text5_i);
    } else {
        TFT.background(back5);
        TFT.foreground(text5);
    }
    printf(" Exit                                       \n");
    //--------------------------------------*-------------------------
    TFT.background(back5);
    TFT.foreground(text5);
    printf("--------------------------------------- \n");


}
//------------------------------------------------------------------------------------------------------------
void drawScreen6(void)                                                                   //экран 6
{
    if (complit==0) {
        TFT.background(Black);
        TFT.foreground(White);
        TFT.cls();
        complit = 1;  // прорисовали!
    }
    TFT.set_font((unsigned char*) digi36x44);
    TFT.foreground(Green);
    TFT.locate(10, 10);
    TFT.printf("%06.1f", Ireal);
    TFT.locate(10, 85);
    TFT.printf("%05.3f", U5);

    TFT.locate(10, 150);
    TFT.printf("%d", int(U30));


}
//------------------------------------------------------------------------------------------------------------
void drawScreen7(void)                                                                   //экран 7
{
    if (complit==0) {
        TFT.background(Blue);
        TFT.foreground(White);
        TFT.cls();
        complit = 1;  // прорисовали!
        
        TFT.line(0,40,319,40,Black);
        TFT.line(0,80,319,80,Black);
        TFT.line(0,120,319,120,Black);
        TFT.line(0,160,319,160,Black);
        TFT.line(0,200,319,200,Black);
    }
    
    TFT.background(Blue);
    TFT.foreground(White);
    iiii++;
    if (iiii==320) {
        iiii=0;
        TFT.background(Blue);
        TFT.foreground(White);
        TFT.cls();
        TFT.line(0,40,319,40,Black);
        TFT.line(0,80,319,80,Black);
        TFT.line(0,120,319,120,Black);
        TFT.line(0,160,319,160,Black);
        TFT.line(0,200,319,200,Black);
    }
    int b = noisea1*40; 
    TFT.locate(5,5);
    TFT.set_font((unsigned char*) Courier8x13);
    printf("I A1 noise= %0.1f, avg= %0.5f \n", noisea1, in1);
    printf(" I real = %06.1f set zero   \n", Ireal);
    TFT.line(iiii,245-b,iiii,240-b, White);
    //TFT.pixel(iiii,240-b,White);
    
    wait(0.01);
}
//------------------------------------------------------------------------------------------------------------
void drawScreen8(void)                                                                   //экран 8
{
    if (complit==0) {
        TFT.background(Black);
        TFT.foreground(White);
        TFT.cls();
        complit = 1;  // прорисовали!
    }

    TFT.set_font((unsigned char*) Lucida13x21);
    char buffer[32];
    seconds=time(NULL);
    strftime(buffer, 32, "%H:%M:%S %d.%m.%Y", localtime(&seconds));
    TFT.background(back5_i);
    TFT.foreground(text5_i);
    TFT.locate (30,25);
    printf("%s", buffer);    //вывод реального времени
}
//------------------------------------------------------------------------------------------------------------
float map(float x, float in_min, float in_max, float out_min, float out_max)             // функция масштабирования
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}
//------------------------------------------------------------------------------------------------------------
float avgAin0()                                                        // функция среднего значения с входа A0
{
    int m = 100;
    float     value[m];
    float     max;
    float     min;
    double    itg;
    max = itg = 0.0;
    min = 3.3;
    for (int i=0; i<m; i++) {
        value[i] = ainA0;
        if (value[i] > max) max = value[i];
        if (value[i] < min) min = value[i];
        itg += value[i];
    }
    noisea0 = (max - min)*1000;
    return itg/m;
}
//------------------------------------------------------------------------------------------------------------
float avgAin1()                                                        // функция среднего значения с входа A1
{
    float     value[100];
    float     max;
    float     min;
    double    itg;
    max = itg = 0.0;
    min = 3.3;
    for (int i=0; i<100; i++) {
        value[i] = ainA1;
        if (value[i] > max) max = value[i];
        if (value[i] < min) min = value[i];
        itg += value[i];
    }
    noisea1 = (max - min)*1000;
    return itg/100;
}
//------------------------------------------------------------------------------------------------------------
float avgAin2()                                                        // функция среднего значения с входа A2
{
    float     value[100];
    float     max;
    float     min;
    double    itg;
    max = itg = 0.0;
    min = 3.3;
    for (int i=0; i<100; i++) {
        value[i] = ainA2;
        if (value[i] > max) max = value[i];
        if (value[i] < min) min = value[i];
        itg += value[i];
    }
    noisea2 = (max - min)*1000;
    return itg/100;
}
//------------------------------------------------------------------------------------------------------------
float avgAin3()                                                        // функция среднего значения с входа A3
{
    float     value[100];
    float     max;
    float     min;
    double    itg;
    max = itg = 0.0;
    min = 3.3;
    for (int i=0; i<100; i++) {
        value[i] = ainA3;
        if (value[i] > max) max = value[i];
        if (value[i] < min) min = value[i];
        itg += value[i];
    }
    noisea3 = (max - min)*1000;
    return itg/100;
}
//------------------------------------------------------------------------------------------------------------
void dataProcessing(void)                                 // обработка и подготовка данных с аналоговых входов
{
    /*t.reset();// FPS
    t.start();// FPS*/

    in0 = avgAin0();
    in1 = avgAin1();
    in2 = avgAin2();
    in3 = avgAin3();
    //in4 = avgAin4();
    //in5 = avgAin5();

// A0  U real   U = (avgAin0() - a0a) * a0k
// A1  I real   I = (avgAin1() - a1a) * a1k
// A2  U set    U = (avgAin2() - a2a) * a2k
// A3  I set    I = (avgAin3() - a3a) * a3k
// A4  U usb    U = (avgAin4() - a4a) * a4k
// A5  I usb    I = (avgAin5() - a5a) * a5k

    Ireal = a1k*1000*(in1-a1a);

    temperature = map(in3, 0.228, 0.188 , 0, 90); //(in3, 0.232, 0.188 , 0, 90); //преобразование температуры

    if (rdown_on==1) {
        U5 = a0k*(in0-a0a)+Ireal*rdown/1000;
        U30 = a2k*(in2-a2a)+Ireal*rdown/1000;
    } else {
        U5 = a0k*(in0-a0a);
        U30 = a2k*(in2-a2a);
    }

    if (cc==1) ledcc=0;
    if (cc==0) ledcc=1;

    /*t.stop();// FPS
    TFT.background(Black);// FPS
    TFT.foreground(Green);// FPS
    TFT.set_font((unsigned char*) Courier8x13);// FPS
    TFT.locate(260,225);// FPS
    TFT.printf("%0.2f", (1/t.read()));// FPS*/
}
//------------------------------------------------------------------------------------------------------------
void buttonUse(void)                                                               // обработка нажатий кнопок
{
    if (beeper==1) {

        if (buttonEnter==0) {
            buzzer.beep(300,0.01);
        }
        if (buttonDown==0) {
            buzzer.beep(300,0.01);
        }
        if (buttonUp==0) {
            buzzer.beep(300,0.01);
        }
    }




    int one=0; // для обработки одной кнопки за раз
//------------------------------------------------------------------
    if (Screen==1 & one==0) {                        //главный экран
        if (buttonEnter==0) { // Enter
            //wait(1);
            Screen=5;         // 5 главная настройки
            complit=0;
        }
        if (buttonDown==0) {  // Down
        if (powerMosfet==0){
            a1a = in1 - 0.000100f;         // 2
            complit=0;
        }
        }
        if (buttonUp==0) {    // Up
            powerProtect=!powerProtect;
            pp=0;
            wait(0.2);
        }
        one=1;
    }
//------------------------------------------------------------------
    if (Screen==2 & one==0) {               //экран 2 analog in, noise
        if (buttonEnter==0) {  // Enter
            //wait(1);
            Screen=5;          //3
            complit=0;
        }
        if (buttonDown==0) {  // Down
            Screen=7;
            iiii=0;
            complit=0;
        }
        one=1;
    }
//------------------------------------------------------------------
    if (Screen==3 & one==0) {             //экран 3
        if(nline==7 & pmenu==1) {
            wait(0.2);
            pmenu=0;
        }
        if (buttonEnter==0 & pmenu==0) {           // Enter
            pmenu=1;
            wait(0.2);
            if(nline==7) {
                mon=mon-1;
                SetDateTime();
                mon=mon+1;
            }
            if(nline==8) {
                pmenu=0;
                Screen=5;
                complit=0;
            }
        }
        if (buttonUp==0 & pmenu==0) {           // Up
            nline--;
            wait(0.2);
            if (nline==0) nline=8;
        }
        if (buttonDown==0 & pmenu==0) {           // Down
            nline++;
            wait(0.2);
            if (nline==9) nline=1;
        }

        if (pmenu==1) {
            if (buttonEnter==0) {
                pmenu=0;
                wait(0.2);
            }
            if (buttonUp==0) {
                if (nline==1) {
                    hour++;
                    wait(0.1);
                }
                if (nline==2) {
                    min++;
                    wait(0.1);
                }
                if (nline==3) {
                    sec++;
                    wait(0.1);
                }
                if (nline==4) {
                    day++;
                    wait(0.1);
                }
                if (nline==5) {
                    mon++;
                    wait(0.1);
                }
                if (nline==6) {
                    year++;
                    wait(0.1);
                }
            }
            if (buttonDown==0) {
                if (nline==1) {
                    hour--;
                    wait(0.1);
                }
                if (nline==2) {
                    min--;
                    wait(0.1);
                }
                if (nline==3) {
                    sec--;
                    wait(0.1);
                }
                if (nline==4) {
                    day--;
                    wait(0.1);
                }
                if (nline==5) {
                    mon--;
                    wait(0.1);
                }
                if (nline==6) {
                    year--;
                    wait(0.1);
                }
            }

            one=1;
        }
    }
//------------------------------------------------------------------
    if (Screen==4 & one==0) {              //экран меню Калибровка
        if (buttonEnter==0) {             // Enter set!

            if (kline==1) a0a = in0;
            if (kline==2) a0k = 1.900f/(in0-a0a);         //a0k = umax/(in0-a0a);

            if (kline==3) a1a = in1 - 0.000100f;         // a1a = avgAin1() - 0.00004
            if (kline==4) a1k = 0.2f/(in1 - a1a);        //a1k = 1000/(avgAin1() - a1a) при 1амперах

            if (kline==5) a2a = in2;                     // U high v
            if (kline==6) a2k = 19.00f/(in2-a2a);        // U high v
            
            if (kline==10) 
            {
                ledshort=1;  // 1 раз моргнуло - начало записи
                wait(0.02);
                ledshort=0;
                wait(0.05);
                int s=1;
                int s1=0;
                eeprom.nbyte_write(0, (char*)&s, sizeof(s));
                eeprom.nbyte_write(4, (char*)&s1, sizeof(s1));
                ledshort=1;
                wait(0.02);
                ledshort=0;
            }
            if (kline==11) 
            {
                ledshort=1;  // 1 раз моргнуло - начало записи
                wait(0.02);
                ledshort=0;
                wait(0.05);
                int s=0;
                int s1=1;
                eeprom.nbyte_write(0, (char*)&s, sizeof(s));
                eeprom.nbyte_write(4, (char*)&s1, sizeof(s1));
                ledshort=1;
                wait(0.02);
                ledshort=0;
            }

            if (kline==13) {          // load

                a0a = 0.000679;
                a0k = 5.006402;
                a1a = 0.143353;
                a1k = 3.224676;
                a2a = 0.000015;
                a2k = 33.627953;
            }
            if (kline==14) {                  // save
                ledshort=1;  // 1 раз моргнуло - начало записи
                wait(0.02);
                ledshort=0;
                wait(0.05);
                eeprom.nbyte_write(8, (char*)&a0a, sizeof(a0a));    // a0a float - 4 байта
                eeprom.nbyte_write(12, (char*)&a0k, sizeof(a0k));    // a0k float - 4 байта
                eeprom.nbyte_write(16, (char*)&a1a, sizeof(a1a));   // a1a float - 4 байта
                eeprom.nbyte_write(20, (char*)&a1k, sizeof(a1k));   // a1k float - 4 байта
                eeprom.nbyte_write(24, (char*)&a2a, sizeof(a2a));   // a2a float - 4 байта
                eeprom.nbyte_write(28, (char*)&a2k, sizeof(a2k));   // a2k float - 4 байта
                ledshort=1;  // 2 раз моргнуло - записалось
                wait(0.02);
                ledshort=0;
                wait(0.1);
            }
            if (kline==15) Screen=5; //exit
            complit=0;
        }

        if (buttonUp==0) {           // Up
            kline--;                 //-
            if (kline==0) kline=15;
        }

        if (buttonDown==0) {         // Down
            kline++;                 //+
            if (kline==16) kline=1;
        }
        one=1;
    }
//------------------------------------------------------------------
    if (Screen==5 & one==0) {                  //экран 5 Настройки главная-------------------------------------------------------
        if (buttonEnter==0 & pmenu==0) {           // Enter

            if (mline==1) {
                Screen=3;
                complit=0;
            }

            if (mline==2) {
                mline2=1;
                pmenu=1;
                one=1;
                wait(0.2);
            }

            if (mline==3) {             // sound beeper
                beeper=!beeper;
                ledshort=1;
                wait(0.02);
                ledshort=0;
                wait(0.05);
                eeprom.nbyte_write(44, (char*)&beeper, sizeof(beeper));     // beeper float - 4 байта
                ledshort=1;
                wait(0.02);
                ledshort=0;
                mline7=1;
                pmenu=1;
                one=1;
                wait(0.2);
            }

            if (mline==4) {             // вентилятор старт
                mline4=1;
                pmenu=1;
                one=1;
                wait(0.2);
            }

            if (mline==5) {             // вентилятор full
                mline5=1;
                pmenu=1;
                one=1;
                wait(0.2);
            }

            if (mline==6) {             // температура отключения нагрузки
                mline6=1;
                pmenu=1;
                one=1;
                wait(0.2);
            }

            if (mline==7) {            // R падение U вкл выкл
                rdown_on=!rdown_on;
                ledshort=1;
                wait(0.02);
                ledshort=0;
                wait(0.05);
                eeprom.nbyte_write(48, (char*)&rdown_on, sizeof(rdown_on));    // rdown_on float - 4 байта
                ledshort=1;
                wait(0.02);
                ledshort=0;
                mline7=1;
                pmenu=1;
                one=1;
                wait(0.2);
            }

            if (mline==8) {            // сопротивление R номинал
                mline8=1;
                pmenu=1;
                one=1;
                wait(0.2);
            }

            if (mline==9) {            // меню калибровки
                Screen=4;
                complit=0;
            }

            if (mline==10) {          // меню analog in, noise
                Screen=2;
                complit=0;
            }

            if (mline==11) {             // U максимальная
                mline11=1;
                pmenu=1;
                one=1;
                wait(0.2);
            }

            if (mline==12) {           // I max
                mline12=1;
                pmenu=1;
                one=1;
                wait(0.2);
            }

            if (mline==13) {          // screen saver
                mline13=1;
                pmenu=1;
                one=1;
                wait(0.2);
            }

            if (mline==14) {        // загрузить в память настройки по умолчанию и нужно перезагрузиться
                savedefaulttoflash();
                mline14=1;
                pmenu=1;
                one=1;
                wait(0.2);
            }

            if (mline==15) {
                Screen=1;
                complit=0;
            }
        }

        if (buttonUp==0 & pmenu==0) {              // Up
            mline--;                    //-
            if (mline==0) mline=15;
        }

        if (buttonDown==0 & pmenu==0) {            // Down
            mline++;                    //+
            if (mline==16) mline=1;
        }

        //---------подменю яркость подсветки
        if (mline2==1) {
            int i=0;
            if (buttonUp==0 && brightness<1) {
                if(brightness >= 0.09f && i==0) {
                    brightness+=0.1f;
                    pinbrightness=brightness;
                    i=1;
                }
                if(brightness < 0.09f && i==0) {
                    brightness+=0.01f;
                    pinbrightness=brightness;
                    i=1;
                }

            }

            if (buttonDown==0 && brightness>0.01f) {
                if(brightness <= 0.1f && i==0) {
                    brightness-=0.01f;
                    pinbrightness=brightness;
                    i=1;
                }
                if(brightness > 0.1f && i==0) {
                    brightness-=0.1f;
                    pinbrightness=brightness;
                    i=1;
                }
            }

            if (buttonEnter==0) {
                ledshort=1;
                wait(0.02);
                ledshort=0;
                wait(0.05);
                eeprom.nbyte_write(40, (char*)&brightness, sizeof(brightness)); // brightness float - 4 байта
                ledshort=1;
                wait(0.02);
                ledshort=0;
                mline2=0;
                pmenu=0;
            }
        }
        //------------------------------------ tempstart
        if (mline4==1) {
            if (buttonUp==0) {
                tempstart++;
                wait(0.1);
            }
            if (buttonDown==0) {
                tempstart--;
                wait(0.1);
            }
            if (buttonEnter==0) {
                ledshort=1;
                wait(0.02);
                ledshort=0;
                wait(0.05);
                eeprom.nbyte_write(56, (char*)&tempstart, sizeof(tempstart));   // tempstart float - 4 байта
                ledshort=1;
                wait(0.02);
                ledshort=0;
                mline4=0;
                pmenu=0;
            }
        }
        //------------------------------------ tempfull
        if (mline5==1) {
            if (buttonUp==0) {
                tempfull++;
                wait(0.1);
            }
            if (buttonDown==0) {
                tempfull--;
                wait(0.1);
            }
            if (buttonEnter==0) {
                ledshort=1;
                wait(0.02);
                ledshort=0;
                wait(0.05);
                eeprom.nbyte_write(60, (char*)&tempfull, sizeof(tempfull));    // tempfull float - 4 байта
                ledshort=1;
                wait(0.02);
                ledshort=0;
                mline5=0;
                pmenu=0;
            }
        }
        //------------------------------------ tempcutoff
        if (mline6==1) {
            if (buttonUp==0) {
                tempcutoff++;
                wait(0.1);
            }
            if (buttonDown==0) {
                tempcutoff--;
                wait(0.1);
            }
            if (buttonEnter==0) {
                ledshort=1;
                wait(0.02);
                ledshort=0;
                wait(0.05);
                eeprom.nbyte_write(64, (char*)&tempcutoff, sizeof(tempcutoff));  // tempcutoff float - 4 байта
                ledshort=1;
                wait(0.02);
                ledshort=0;
                mline6=0;
                pmenu=0;
            }
        }
        //------------------------------------ падение на R вкл выкл
        if (mline7==1 & one==0) {
            wait(0.1);
            mline7=0;
            pmenu=0;
        }
        //------------------------------------ сопротивление резистора
        if (mline8==1) {
            if (buttonUp==0) {
                rdown=rdown+0.001f;
                wait(0.1);
            }
            if (buttonDown==0) {
                rdown=rdown-0.001f;
                wait(0.1);
            }
            if (buttonEnter==0) {
                ledshort=1;
                wait(0.02);
                ledshort=0;
                wait(0.05);
                eeprom.nbyte_write(36, (char*)&rdown, sizeof(rdown));           // rdown float - 4 байта
                ledshort=1;
                wait(0.02);
                ledshort=0;
                mline8=0;
                pmenu=0;
            }
        }
        //------------------------------------ U max
        if (mline11==1) {
            if (buttonUp==0) {
                umax++;
                wait(0.1);
            }
            if (buttonDown==0) {
                umax--;
                wait(0.1);
            }
            if (buttonEnter==0) {
                ledshort=1;
                wait(0.02);
                ledshort=0;
                wait(0.05);
                eeprom.nbyte_write(52, (char*)&umax, sizeof(umax));        // umax float - 4 байта
                ledshort=1;
                wait(0.02);
                ledshort=0;
                mline11=0;
                pmenu=0;
            }
        }
        //------------------------------------ I max
        if (mline12==1) {
            if (buttonUp==0) {
                imax=imax+0.1f;
                wait(0.05);
            }
            if (buttonDown==0) {
                imax=imax-0.1f;
                wait(0.05);
            }
            if (buttonEnter==0) {
                ledshort=1;
                wait(0.02);
                ledshort=0;
                wait(0.05);
                eeprom.nbyte_write(32, (char*)&imax, sizeof(imax));             // imax float - 4 байта
                ledshort=1;
                wait(0.02);
                ledshort=0;
                mline12=0;
                pmenu=0;
            }
        }
        //------------------------------------ screensaver
        if (mline13==1) {
            if (buttonUp==0) {
                screensaver++;
                if (screensaver==4) screensaver=0;
                wait(0.1);
            }
            if (buttonDown==0) {
                screensaver--;
                if (screensaver==-1) screensaver=3;
                wait(0.1);
            }
            if (buttonEnter==0) {
                ledshort=1;
                wait(0.02);
                ledshort=0;
                wait(0.05);
                eeprom.nbyte_write(68, (char*)&screensaver, sizeof(screensaver));  // screensaver float - 1 байт
                ledshort=1;
                wait(0.02);
                ledshort=0;
                mline13=0;
                pmenu=0;
            }
        }
        //------------------------------------
        if (mline14==1 & one==0) {
            wait(0.1);
            mline14=0;
            pmenu=0;
        }
        //------------------------------------
        one=1;
        //------------------------------------

    }
//------------------------------------------------------------------
    if (Screen==6 & one==0) {                  //экран 6
        if (buttonEnter==0) {  // Enter
            Screen=1;
            complit=0;
        }

        if (buttonUp==0) {     // Up
        }

        if (buttonDown==0) {   // Down
        }
        one=1;

    }
//------------------------------------------------------------------
    if (Screen==7 & one==0) {                  //экран 7
        if (buttonEnter==0) {  // Enter
            Screen=2;
            complit=0;
        }

        if (buttonUp==0) {     // Up
            Screen=2;
            complit=0;
        }

        if (buttonDown==0) {   // Down
            Screen=2;
            complit=0;
        }
        one=1;

    }
//------------------------------------------------------------------
    if (Screen==8 & one==0) {                  //экран 8
        if (buttonEnter==0) {  // Enter
        }

        if (buttonUp==0) {     // Up
        }

        if (buttonDown==0) {   // Down
        }
        one=1;

    }
//------------------------------------------------------------------
}
//------------------------------------------------------------------------------------------------------------
void grid(void)
{
    TFT.cls();
    for (int i=0; i<240; i=i+5) {
        TFT.line(0,i,320,i, White);
    }
    for (int i=2; i<240; i=i+5) {
        TFT.line(4,i,320,i, White);
    }
    for (int i=3; i<240; i=i+5) {
        TFT.line(4,i,320,i, White);
    }

}
//------------------------------------------------------------------------------------------------------------
void timeConvert(void)   //показывает час с минуты с секундами начинают идти с часа и одной минуты
{
    if (powerMosfet==1) treal = time(NULL);
    t = treal - tstart;
    h= t/3600;
    m= (t-h*3600)/60;
    s= (t-h*3600)-m*60;
    if (t == 359999) tstart=treal;
}
//------------------------------------------------------------------------------------------------------------
void SetDateTime (void)
{
    struct tm Clock;
    Clock.tm_year = year - 1900;
    Clock.tm_mon  = mon;
    Clock.tm_mday = day;
    Clock.tm_hour = hour;
    Clock.tm_min  = min;
    Clock.tm_sec  = sec;
    time_t epoch = mktime(&Clock);
    set_time(epoch);
}
//------------------------------------------------------------------------------------------------------------*/
void powerButton(void)                                                           // при нажатии кнопки питания
{
    if (onepower==0) {
        timerforpoweriddle.attach(&keypoweriddle, 0.5);

        if (saveractive==0) {
            powerMosfet=!powerMosfet;
            iddletimesaver.detach();
            onesaver=0;
            saveractive=0;
        } else {
            iddletimesaver.detach();
            onesaver=0;
            saveractive=0;
        }

        if (beeper==1) {
            buzzer.beep(1600,0.05);
        }
        onepower=1;
        pb=0;

    }
    if (powerMosfet==1) {
        tstart = treal = time(NULL);
        h=m=s=0;
    }
}
//------------------------------------------------------------------------------------------------------------
void fans(void)
{
    if (temperature < (tempstart-2)) {
        fst=0;
        fst2=0;
        fan = 0.0f;
        //fan2 = 0.0f;
    }

    if (temperature >= tempstart && fst == 0) {
        fan = 1.0f;
        //fan2 = 1.0f;
        timerforfanstart.attach(&fanstart, 2.0);
        fst=1;
    }

    if (fst2==1) {
        fanspeed = map (temperature, tempstart, tempfull, 0.4, 1);
        fan = fanspeed;
        //fanspeed2 = map (temperature, tempstart, tempfull, 0.4, 1);
        //fan2 = fanspeed2;    
    }

    if (temperature >= tempcutoff) {
        powerMosfet=0;
        pb=0;
    }

}
//------------------------------------------------------------------------------------------------------------
void fanstart(void)
{
    fst2=1;
}
//------------------------------------------------------------------------------------------------------------
void keypoweriddle(void)
{
    onepower=0;
}
//------------------------------------------------------------------------------------------------------------
void Protect(void)
{
    // powerProtect==0  pp==0   защита от кз
    // cs==0            csp==0  прорисовка короткого замыкания
    if (U5<0.9f && cc==0) {
        shortline=1;
    } else {
        shortline=0;
    }
    if (shm==!shortline) {
        shl=0;
    }

    if (shortline==1 && shl==0) {
        cs=1;
        csp=0;
        shl=1;
        shm=shortline;
        ledshort=1;
    }

    if (shortline==0 && shl==0) {
        cs=0;
        csp=0;
        shl=1;
        shm=shortline;
        ledshort=0;
    }

    if (powerProtect==1) {
        if (U5<0.9f && cc==0) {
            powerMosfet=0;
            pb=0;
            if (beeper==1) {
                buzzer.beep(480,0.3);
            }
        }
    }
}
//------------------------------------------------------------------------------------------------------------
void ScreenSaver(void)
{
    if (screensaver != 0) {
        if (buttonEnter==0) {
            iddletimesaver.detach();
            onesaver=0;
            saveractive=0;
        }
        if (buttonDown==0) {
            iddletimesaver.detach();
            onesaver=0;
            saveractive=0;
        }
        if (buttonUp==0) {
            iddletimesaver.detach();
            onesaver=0;
            saveractive=0;
        }
    }
    if (Screen==8 && saveractive==0) {
        Screen=1;
        complit=0;
    }
    if (Screen == 1 && onesaver==0) {
        if (powerMosfet == 0 && screensaver != 0) {
            iddletimesaver.attach(&screensaverstart, 10.0);
            onesaver=1;
        }
    }
}
//------------------------------------------------------------------------------------------------------------
void screensaverstart(void)
{
    saveractive=1;
    Screen=8;
    complit=0;
}
//------------------------------------------------------------------------------------------------------------