#include "mbed.h"
#include "string"
#define INT_TIME 0.02


Ticker timer;
RawSerial pc(USBTX,USBRX,115200);
RawSerial Master(D5,D4,115200);

DigitalIn sw2(D2);
DigitalIn sw3(D3);
DigitalIn sw6(D6);
DigitalIn sw7(D7);
DigitalIn sw8(D8);
DigitalIn sw9(D9);
DigitalIn sw10(D10);

AnalogIn joyR_x(A6);
AnalogIn joyR_y(A5);
AnalogIn joyL_x(A4);
AnalogIn joyL_y(A3);

bool per_rotR, pre_rotL, pre_up, pre_down, pre_handR, pre_handL, pre_other;

bool sw_in(int sw, int pre_sw){
    bool rt_sw;
    if (sw == true && pre_sw == false) rt_sw = true;
    else rt_sw = false;
    return rt_sw;
}

void timer_warikomi(){
    
    double d_joyR = joyR_x.read();
    double d_joyL = joyL_x.read();
    
    bool rotR = sw2.read();
    bool rotL = sw3.read();
    bool up = sw6.read();
    bool down = sw7.read();
    bool handR = sw8.read();
    bool handL = sw9.read();
    bool other = sw10.read();
    
    char buttons = 0b00000000;
    
    if(sw_in(rotR,per_rotR))   buttons |= 0b00000001;
    if(sw_in(rotL,pre_rotL))   buttons |= 0b00000010;
    if(sw_in(up,pre_up))       buttons |= 0b00000100;
    if(sw_in(down,pre_down))   buttons |= 0b00001000;
    if(sw_in(handR,pre_handR)) buttons |= 0b00010000;
    if(sw_in(handL,pre_handL)) buttons |= 0b00100000;
    if(sw_in(other,pre_other)) buttons |= 0b01000000;
    
    char joyR = char(int(255.0 * d_joyR));
    char joyL = char(int(255.0 * d_joyL));
    
    pc.printf("%c%c%c\n",joyR,joyL,buttons);
    
    Master.putc(joyR);
    Master.putc(joyL);
    Master.putc(buttons);
    Master.putc('\n');
    
    per_rotR = rotR;
    pre_rotL = rotL;
    pre_up = up;
    pre_down = down;
    pre_handR = handR;
    pre_handL = handL;
    pre_other = other;
}

int main()
{
    
    timer.attach(&timer_warikomi,INT_TIME);
    
    while(true) {}
}

