#include "mbed.h"
#include "string"
Ticker timer;

RawSerial BT(p13, p14, 115200);
RawSerial pc(USBTX,USBRX,115200);
bool Connected = 0;
bool mldp_online = 0;
string recv_str = "";

void BT_recv(){
    char bt_c = BT.getc();
    if(bt_c == 'd') {
        Connected = 1;
        recv_str += bt_c;
        }
    if (Connected && bt_c == 'P') recv_str = "";
    else recv_str += bt_c;
}

void set(){
    wait(1.0);
    BT.printf("+\r");
    wait(0.5);
    BT.printf("SF,1\r");
    wait(0.5);
    BT.printf("SR,32000000\r");
    wait(0.5);
    BT.printf("R,1\r");
    wait(4.0);
    BT.printf("A\r");
}

void timer_warikomi(){
    static int time_co = 0; 
    if(Connected && !mldp_online && time_co > 25) {
        BT.printf("I\r");
        mldp_online = 1;
        pc.printf(recv_str.c_str());
        pc.printf("MLDP_ONLINE\n");
        recv_str = "";
    }
    else if (Connected && mldp_online){
            BT.printf("Slave_on\n");
            pc.printf(recv_str.c_str());
            recv_str = "";
    }
    else {
        pc.printf(recv_str.c_str());
        time_co++;
    }
}

int main() {
    BT.attach(&BT_recv,RawSerial::RxIrq);
    
    set();
    
    timer.attach(&timer_warikomi,0.02);
    while(1) {
    }
}
