#include "mbed.h"
#include "string"
#include "define.h"

Ticker timer;

RawSerial BT(p28, p27, 115200);
RawSerial pc(USBTX,USBRX,115200);

DigitalOut led(LED1);

string BT_str = "";
string address = "";
int search_bt = 0;
bool Connected = 0;
bool mldp_online = 0;
int str_count = 0;
char x = 127, y = 127, rot = 127;
char mode = 127;

void BT_recv(){
    char bt_c = BT.getc();
    if (bt_c == 'd' && !Connected) {
        BT_str += bt_c;
        Connected = 1;
        BT_str = "";
    }
    if (Connected && mldp_online && bt_c == '\r'){
        if (BT_str == "Connection End"){
            Connected = 0;
            led = 1;
        }
        pc.printf(BT_str.c_str());
        BT_str == "";
    }
    if (Connected && mldp_online && bt_c == '\n'){
        x = BT_str[0];
        y = BT_str[1];
        rot = BT_str[2];
        mode = BT_str[3];
        pc.printf("%d\t%d\t%d\t%x\n",x,y,rot,mode);
        BT_str = "";
    }
    else {
        BT_str += bt_c;
    }
}

void send_cmd (string cmd){
    BT.printf(cmd.c_str());
}

void set(){
    wait(1.0);
    send_cmd("+\r");
    wait(0.5);
    send_cmd("SF,1\r");
    wait(0.5);
    send_cmd("SR,92000000\r");
    wait(0.5);
    send_cmd("R,1\r");
    wait(4.0);
    send_cmd("F\r");
    wait(0.5);
    send_cmd("X\r");
    wait(0.5);
    send_cmd("E,0,0491621AD835\r");
}

void timer_warikomi(){
    static int time_co = 0;
    if (Connected && !mldp_online && time_co > 10) {
        send_cmd("I\r");
        pc.printf(BT_str.c_str());
        pc.printf("MLDP_ONLINE\n");
        mldp_online = 1;
        BT_str = "";
    }
    else if (Connected && mldp_online){
            //pc.printf("x:%d\ty:%d\trot:%d\tmode:%d\n",x,y,rot,mode);
    }
    else {
        //pc.printf(BT_str.c_str());
        time_co++;
    }
}

int main() {
    led = 0;
    BT.attach(&BT_recv,RawSerial::RxIrq);
    
    set();
    
    timer.attach(&timer_warikomi,0.1);
    
    while(true) {
    }
}
