#include "PID.h"

PID::PID(double _INT_TIME){
    _time = _INT_TIME;
    _pre_err = 0;
    reset();
}

void PID::set(double _P, double _I, double _D){
    _p = _P;
    _i = _I;
    _d = _D;
}

double PID::con (double _error){
    double _result = 0;
    
    _result += _error * _p;
    
    _integ += (_error + _pre_err) / 2.0 * _time;
    _result += _integ * _i;
    
    _result += (_error - _pre_err) / _time * _d;
    
    _pre_err = _error;
    
    return _result;
}
    
void PID::reset(){
    _p = 0.0;
    _i = 0.0;
    _d = 0.0;
    _integ = 0.0;
}

void PID::Ireset(){
    _integ = 0.0;
}