#include "Serie.h"

//INSTANCIATION DES INSTANCES GLOBALES ET EXTERNES
Serial xbee(XBEE_PIN_TX,XBEE_PIN_RX);

//INSTANCES GLOBALES ET INTERNES
char commande[TAILLE_COMMANDE];
int curseur;
bool wait_com;


/* LA COMMANDE POUR PAPI BROSSARD
reception d'un chaine :"Cam:23521/4521/451/.../6532/\n"
Utilisation du split java avec pour delimiteur / et :
String s="27/03/2008";
String str[]=s.split("/");

On peut eventuellement utilisé la classe Scanner de JAVA*/
void envoyerCamera()
{
    xbee.printf("Cam:");
    for(int i=0;i<128;i++) {
        xbee.printf("%u/",valeurs[i]);
    }
    xbee.printf("\n");
}

typedef enum IdVar IdVar;
enum Idvar {CAM1,TASSERV,VPROP,};

//Si quelqu'un trouve pourquoi un parametre de type enumeration n'est pas accepte par le compilo
/*void getVar(IdVar id) {
    switch(id) {
        case CAM1 :
            envoyerCamera();
            break;
            
    }
}*/

void getVar(int id) {
    switch(id) {
        case CAM1 :
            envoyerCamera();
            break;
    }
}
void help() {
}

void traiter(char commande[]) {
    switch(commande[0]) {
        case 'G':
            getVar(commande[1]);
            
           break;
            
        case 'S':
            int t;
            sscanf(commande, "S%d\n",t);
            //setTIntegration(t);
            
           break;
        case 'D':
            float t;
            char a,b;
            sscanf(commande,"%c%c%f\n",&a,&b,&t);
            
            switch(commande[2]) {
                case 'P':
                    propulsion.setDKp(t);
                  break;
                case 'I':
                    propulsion.setDKi(t);
                  break;
                case 'D':
                    propulsion.setDKd(t);
                  break;
                }
            break;
        case 'L':
            float w;
            char a,b;
            sscanf(commande,"%c%c%f\n",&a,&b,&w);
            
            switch(commande[2]) {
                case 'P':
                    propulsion.setGKp(w);
                  break;
                case 'I':
                    propulsion.setGKi(w);
                  break;
                case 'D':
                    propulsion.setGKd(w);
                  break;
                }
            break;
            
        case 'C':
            setDirection(((float)commande[1])/(2000*256.0f));
            float a1 = (float)commande[1]/(2000*256.0f);
            float a2 = (commande[2]-128.0f)/128.0f;
            float a3 = (commande[3]-128.0f)/128.0f;
            //setPuissanceMoteurs((commande[2]-128.0f)/(128.0f),(commande[3]-128.0f)/(128.0f));
            xbee.printf("Commande (C)ontrol reconnue\n");
            xbee.printf("  C:%s dir(int):%d M1(int):%d M2(int):%d\n",commande[0],commande[1],commande[2],commande[3]);
            xbee.printf("  Valeur: Dir(float)%f\n",direction.read());
            xbee.printf("%f %f %f\n\n\n",a1,a2,a3);

           break;
        
        default:
            xbee.printf("Commande non reconnue\n");
            break;
    }
    xbee.printf("  Commande(ASCII) : %s\n",commande);
}

void callbackSerie() {
    int donne;
    
    while(xbee.readable())
    {
        donne = xbee.getc();
    
        if(wait_com) {
            /*On ecoute la commande*/
        
            if(donne == '\n') {
                /*Fin de la commande*/
                if(curseur != 0) {
                    commande[curseur] = '\n';
                    traiter(commande);
                }
                wait_com = false;
            } else {
                if(curseur >= TAILLE_COMMANDE) {
                    xbee.printf("Xbee Freescale: Buffer overflown");
                    wait_com = false;
                } else {
                    commande[curseur] = donne;
                    curseur++;
                }    
            }
            
        } else {
            /*On attends le symbole START pour prendre commande*/
            if(donne == 'S') {
                wait_com = true;
                curseur = 0;
            }
        }
    }
}


void initSerie() {
    for(int i=0 ; i< TAILLE_COMMANDE ; i++) {
        commande[i] = 0;
    }
    xbee.baud(XBEE_SPEED);
    xbee.printf("Xbee Freescale: Hello...\n");
    xbee.attach(&callbackSerie);
    curseur = 0;
    wait_com = false;
}
