#include "Pid.h"

Pid::Pid()
{
    this->kp = 0;
    this->ki = 0;
    this->kd = 0;
}

Pid::Pid(float Kp, float Ki, float Kd)
{
    this->kp = Kp;
    this->ki = Ki;
    this->kd = Kd;
}

void Pid::setKp(float Kp)
{
    this->kp = Kp;
}
void Pid::setKi(float Ki)
{
    this->ki = Ki;
}

void Pid::setKd(float Kd)
{
    this->kd = Kd;
}
float Pid::getCommande(float p_erreur, float i_erreur, float d_erreur)
{
    return this->kp * p_erreur +
        this->ki * i_erreur +
        this->kd * d_erreur;
}

float Pid::getCommande(Erreur e)
{
    return this->getCommande(e.p,e.i,e.d);   
}