#include "mbed.h"

DigitalOut gpo(D0);
DigitalOut led(LED_RED);
Serial xbee(D1,D0);
AnalogIn FBA(PTB10); //Feedback moteur A
AnalogIn FBB(PTB11); //Feedback moteur B
PwmOut moteurA1(PTD1);
PwmOut moteurA2(PTD3);
PwmOut moteurB1(PTD2);
PwmOut moteurB2(PTD0);
PwmOut direction(PTC4);
char commande[10];
int curseur;



void setDirection(float dir) {
    direction.write(dir);
}

    
void setMoteurs(float m1, float m2) {
    if (m1>0) {
        moteurA2.write(0);
        moteurA1.write(m1);
    }
    else {
        moteurA1.write(0);
        moteurA2.write(-m1);
    }
    
    if (m2>0) {
        moteurB2.write(0);
        moteurB1.write(m2);
    }
    else {
        moteurB1.write(0);
        moteurB2.write(-m2);
    }
}
    
    

void tourneDroite(int angle, PwmOut s) {
    s.write(s.read() + valeurServo(angle));
    }    
    
int pourcentServo(float v) {
    return v*2000;
    }
    
float valeurServo(int p) {
    return (float)p/2000;
    }

    
    
void commande(int dir, int m1, int m2) {
    setDirection((float)dir-128.0f)/128.0f);
    setMoteurs((m-128.0f)/128.0f,(m2-128.0f)/128.0f);
}
    
    
    
/*
void getVar(int idVar) {
    switch(idVar) {
        case 
    }
}
*/

void traiter(char commande[]) {
    switch(commande[0]) {
        /*case 'S':
        setVar(commande[1]);
        case 'G':
        xbee.printf(getVar(commande[1]));
        */
        case 'C':
           commande(commande[1],commande[2],commande[3]);
        
        default:
        xbee.printf("Commande non valide");
    }
}

void callback() {
    char donne = xbee.getc();
    
    if(donne == '\n') {
        if(curseur!=0) {
           commande[curseur] = '\n';
           traiter(commande);
           curseur = 0;
        }
    } else {
            commande[curseur] = donne;
            curseur++;
    }
}

void init() {
    curseur = 0;
    for(int i=0:i<10;i++) {
        commande[i] = '\n';
    }
    moteurA1.period(0.0001f);
    moteurA2.period(0.0001f);
    moteurB1.period(0.0001f);
    moteurA2.period(0.0001f);
    direction.period(0.014286f);
}

int main()
{
    init();
    xbee.baud(9600);
    xbee.printf("Xbee Freescale: Hello...\n");
    xbee.attach(&callback);
    
    while (true) {
        gpo = !gpo; // toggle pin
        led = !led; // toggle led
        wait(0.2f);
    }
}