#include <stdlib.h>
#include <SDL2/SDL.h>
#include <stdio.h>
#include <termios.h>
#include <sys/fcntl.h>
#include <unistd.h>


int initSerie() {

    int descripteur;
    struct termios  config;
    char *port = "/dev/ttyUSB0"

    /* Ouverture de la liaison serie */
    if ( (fd=open(port,O_RDWR)) == -1 ) {
        perror("open");
        exit(-1);
    }

    /* Lecture des parametres courants */
    tcgetattr(fd,&config);

    /*--------------CONFIG-------------------*/
    /* On ignore les BREAK et les caracteres avec erreurs de parite */
    config.c_iflag = IGNBRK | IGNPAR;
    /* Pas de mode de sortie particulier */
    config.c_oflag = 0;
    /* Liaison a 9600 bps avec 7 bits de donnees et une parite paire */
    /*config.c_cflag = B9600 | CS7 | PARENB;*/
    config.c_cflag = CS7 | PARENB;
    /* Mode non-canonique avec echo */
    /*config.c_lflag = ECHO;*/
     config.c_lflag = 0; /*Pas d'echo pas canonique*/
    /* Caracteres immediatement disponibles */
    config.c_cc[VMIN] = 1;
    config.c_cc[VTIME] = 0;
    /*Vitesse reglage*/
    cfsetispeed(&config, B9600);
    cfsetospeed(&config, B9600);

    /* Sauvegarde des nouveaux parametres(Modif immédiate TCSANOW)*/
    tcsetattr(fd,TCSANOW,&config);

    return descripteur;
}

void envoiCommande(char dir, char md, char mg, int fd){
    char commande[10];
    commande[0] = 'S';
    commande[1] = 'C';
    commande[2] = dir;
    commande[3] = md;
    commande[4] = mg;
    commande[5] ='\n';
    write(fd,commande,6);
}

int main(int argc, char **argv)
{
    int fd = initSerie();


    if(SDL_Init(SDL_INIT_JOYSTICK) < 0) // initialise le joystick
        return EXIT_FAILURE;


    SDL_Joystick *joystick; // on crée le joystick
    joystick = SDL_JoystickOpen(0); // on l'assigne au numéro 0
    SDL_Event evenements;
    Sint16 dir;
    Sint16 propulsion;

    //SDL_JoystickEventState(SDL_ENABLE);
    while(1)
    {
        while(SDL_PollEvent(&evenements)) // tant qu'il y a des évènements à traiter
        {
            switch(evenements.type)
            {
            case SDL_JOYAXISMOTION:
                if(evenements.jaxis.axis == 0 && evenements.jaxis.which == 1)
                {
                    dir = evenements.jaxis.value;
                }
                if(evenements.jaxis.axis == 1 && evenements.jaxis.which == 2)
                {
                    propulsion = evenements.jaxis.value;
                }
                break;
                envoiCommande(dir,propulsion,propulsion,fd);

            default:
                break;
            }
        }
    }
    /* Fermeture */
    SDL_JoystickClose(joystick);
    SDL_Quit();
    close(fd);
    return EXIT_SUCCESS;
}