#include <stdlib.h>
#include <SDL.h>
#include <stdio.h>
#include <termios.h>
#include <sys/fcntl.h>
#include <unistd.h>


int initSerie() {

    int descripteur;
    struct termios  config;
    char const *port = "/dev/ttyUSB0"
    FILE* debugInitSerie = NULL; 
    debugInitSerie = fopen("debugInitSerie.txt","w+");
    
    if(debugInitSerie == NULL)
        return EXIT_FAILURE;
        
    fprintf(debugInitSerie,"Debut\n");
    
    
    /* Ouverture de la liaison serie */
    if ( (descripteur=open(port,O_RDWR)) == -1 ) {
        perror("open");
        fprintf(debugInitSerie,"Erreur ouverture port serie\n");
        exit(-1);
    }

    /* Lecture des parametres courants */
    tcgetattr(descripteur,&config);

    /*--------------CONFIG-------------------*/
    /* On ignore les BREAK et les caracteres avec erreurs de parite */
    config.c_iflag = IGNBRK | IGNPAR;
    /* Pas de mode de sortie particulier */
    config.c_oflag = 0;
    /* Liaison a 9600 bps avec 7 bits de donnees et une parite paire */
    /*config.c_cflag = B9600 | CS7 | PARENB;*/
    config.c_cflag = CS7 | PARENB;
    /* Mode non-canonique avec echo */
    /*config.c_lflag = ECHO;*/
     config.c_lflag = 0; /*Pas d'echo pas canonique*/
    /* Caracteres immediatement disponibles */
    config.c_cc[VMIN] = 1;
    config.c_cc[VTIME] = 0;
    /*Vitesse reglage*/
    cfsetispeed(&config, B9600);
    cfsetospeed(&config, B9600);

    /* Sauvegarde des nouveaux parametres(Modif immédiate TCSANOW)*/
    if(tcsetattr(descripteur,TCSANOW,&config) == -1) {
        fprintf(debugInitSerie,"Erreur tcsetattr\n");
        exit(-1);
    }
    fprintf(debugInitSerie,"InitSerie OK");
    fclose(debugInitSerie);
    return descripteur;
}

void envoiCommande(char dir, char md, char mg, int fd){
    FILE* debugcommande = NULL; 
    debugcommande = fopen("debugcommande.txt","w+");
    char commande[10];
    commande[0] = 'S';
    commande[1] = 'C';
    commande[2] = dir;
    commande[3] = md;
    commande[4] = mg;
    commande[5] ='\n';
    fprintf(debugcommande"%c%c%d%d%d",commande[0],commande[1],commande[2],commande[3],commande[4]);
    fclose(debugcommande);
    write(fd,commande,6);
}

char convert(Sint16 a) {
    int16 b = (int16)a;
    int8 c = b>>8;
    char res = (char) c;
    return res;
}

int main(int argc, char **argv)
{
    FILE debug = NULL;
    debug = fopen("debug.txt","w+");
    
    if(debug == NULL)
        return EXIT_FAILURE;
        
    fprintf(debug,"Debut\n");
    
    int fd = initSerie();

    if(SDL_Init(SDL_INIT_JOYSTICK) < 0){ // initialise le joystick
        return EXIT_FAILURE;
        fprintf(debug,"Erreur init sdl\n");
    }


    SDL_Joystick *joystick; // on crée le joystick
    joystick = SDL_JoystickOpen(0); // on l'assigne au numéro 0
    SDL_Event evenements;
    Sint16 dir;
    Sint16 propulsion;

    SDL_JoystickEventState(SDL_ENABLE);
    while(1)
    {
        while(SDL_PollEvent(&evenements)) // tant qu'il y a des évènements à traiter
        {
            switch(evenements.type)
            {
            case SDL_JOYAXISMOTION:
                if(evenements.jaxis.axis == 0 && evenements.jaxis.which == 0)
                {
                    dir = evenements.jaxis.value;
                    fprintf(debug,"%d",dir);
                }
                if(evenements.jaxis.axis == 1 && evenements.jaxis.which == 0)
                {
                    propulsion = evenements.jaxis.value;
                    fprintf(debug,"%d\n",propulsion);
                }
                break;
                envoiCommande(convert(dir),convert(propulsion),convert(propulsion),fd);

            default:
                break;
            }
        }
    }
    /* Fermeture */
    SDL_JoystickClose(joystick);
    SDL_Quit();
    close(fd);
    close(debug);
    return EXIT_SUCCESS;
}