#include "mbed.h"
#include "EthernetInterface.h"
#include "C12832.h"

C12832 lcd(D11, D13, D12, D7, D10);
DigitalOut led(LED1);
PwmOut r (D5);
PwmOut g (D8);
PwmOut b (D9);
EthernetInterface eth;
TCPSocket client;
TCPServer srv(&eth);

void setRGB(int pot)
{

    r = (float)pot;
    g = (float)(255-pot);
    b = (float)0 ;


}

void setupSocket()
{

    eth.set_network("192.168.0.18","255.255.255.0","192.168.0.1");
    eth.connect();
    printf("The Server IP address is '%s'\n\r", eth.get_ip_address());
    srv.bind(4000);
    srv.listen();
}

void lcdScreen(float temperature){
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("temperature: %d\r\n", temperature);
    }

float temperatureDecoder(uint8_t left, uint8_t right)
{
    uint16_t tempLowHigh = ((left & 0xFF) << 8 ) | (right & 0xFF);
    tempLowHigh =  tempLowHigh >> 5;
//Sign extend negative numbers
    if (tempLowHigh & (1 << 10)) {
        tempLowHigh |= 0xFC00;
    }

//Return the temperature in °C
    return tempLowHigh * 0.125;
}


int main()
{
    printf("Server example\n\r");
    setupSocket();



    while(true) {

        SocketAddress client_addr;
        char *buffer = "Hello TCP client!\r\n";

        srv.accept(&client, &client_addr);

        printf("Accepted %s:%d\n\r", client_addr.get_ip_address(),
               client_addr.get_port());

        client.send(buffer, 256);

        char rbuffer[64];
        int rcount = client.recv(rbuffer, sizeof rbuffer);
        float temperature = temperatureDecoder(rbuffer[1],rbuffer[2]);

        printf("received: %d\r\n", rcount);
        printf("packet PWM: %d\r\n", rbuffer[0]);
        printf("packet temp: %d\r\n", temperature);
        setRGB(rbuffer[0]);
        client.close();

    }
}