#include "Onewire.h"

Onewire::Onewire(PinName oneBus):oneBus_(oneBus){

}
void Onewire::writeBit(int bit) {
    bit = bit & 0x01;
    if (bit) {
        // Write '1' bit
        oneBus_.output();
        oneBus_ = 0;
        wait_us(5);
        oneBus_.input();
        wait_us(60);
    } else {
        // Write '0' bit
        oneBus_.output();
        oneBus_ = 0;
        wait_us(70);
        oneBus_.input();
        wait_us(2);
    }
}

int Onewire::readBit() {
    char result;

    oneBus_.output();
    oneBus_ = 0;
    wait_us(1);
    oneBus_.input();
    wait_us(5);
    result = oneBus_.read();
    wait_us(55);
    return result;

}

int Onewire::init() {
    oneBus_.output();
    oneBus_ = 0;
    wait_us(480);
    oneBus_.input();
    wait_us(60);
    if (oneBus_.read() == 0) {
        wait(0.0001);
        return 1;
    }
    return 0;
}
int Onewire::readByte() {
    int result = 0;

    for (int loop = 0; loop < 8; loop++) {
        // shift the result to get it ready for the next bit
        result >>= 1;

        // if result is one, then set MS bit
        if (readBit())
            result |= 0x80;
    }
    return result;
}
void Onewire::writeByte(char data) {
    // Loop to write each bit in the byte, LS-bit first
    for (int loop = 0; loop < 8; loop++) {
        writeBit(data & 0x01);

        // shift the data byte for the next bit
        data >>= 1;
    }
}
unsigned char Onewire::CRC(unsigned char* addr, unsigned char len) {
    unsigned char i, j;
    unsigned char crc = 0;

    for (i = 0; i < len; i++) {
        unsigned char inbyte = addr[i];
        for (j = 0; j < 8; j++) {
            unsigned char mix = (crc ^ inbyte) & 0x01;
            crc >>= 1;
            if (mix) crc ^= 0x8C;
            inbyte >>= 1;
        }
    }

    return crc;
}

