/* mbed Library - OLEDSeps525f
 * Copyright (c) 2010, sblandford
 * Based on MobileLCD library
 * Copyright (c) 2007/8, sford
 * released under MIT license http://mbed.org/licence/mit
 */
 
#ifndef MBED_OLEDSEPS525F_H
#define MBED_OLEDSEPS525F_H
 
#include "mbed.h"

namespace mbed {

/* Class: OLEDSeps525f
 *  An abstraction of an 160x128 OLED driven by the SEPS525F
 *  such as the Densitron DD-160128FC-1A
 *
 * Example:
 * > // Print messages when the AnalogIn is greater than 50%
 * >
 * > #include "mbed.h"
 * > #include "OLEDSeps525f.h"
 * >
 * > OLEDSeps525f lcd(p5,p6,p7,p8,p9,p10);
 * > 
 * > int main() {
 * >     lcd.printf("Hello World!");
 * > }
 */

class OLEDSeps525f : public Stream {

public:
    /* Constructor: OLEDSeps525f
    *  Create and object for the Seps525f OLED, using SPI and three DigitalOuts
    *
    * Variables:
    *  mosi - SPI data out
    *  miso - SPI data in, not used
    *  clk  - SPI clock
    *  cs   - Chip Select
    *  rst  - reset
    *  rs   - command/data select
    */
    
    OLEDSeps525f(PinName mosi, PinName miso, PinName clk, PinName cs, PinName rst, PinName rs);
    
    virtual void reset();
    virtual void _window(int x, int y, int width, int height);
    virtual void _putp(int colour);

    void command(int value);
    void data(int value);
    void rgbdot(int r, int g, int b);
    void pixel(int value);
    /* Functions foreground and background
    * v - A three-byte RGB code to set the foreground
    *     or background colour
    */
    void foreground(int v);
    void background(int v);
    /* Funtion: orientation
    * set the display orientation in
    * 90 degree steps.
    * o - An integer from 0-3 setting the orientation
    */
    void orientation(int o);
    /* Function: tablength
    * Set the tab length
    * l - An integer representing the number of columns
    */
    void tablength(int l);
    /* Function: locate
    *  Set the text cursor to location x,y
    *
    * Variables:
    *  x - An integer setting the column position
    *  y - An integer setting the row position
    */
    void locate(int column, int row);
    /* Function: newline
    *  Set the text cursor to the start of the next line
    */
    void newline();
    virtual int _putc(int c);
    virtual int _getc() { return 0; }
    SPI _spi;
    DigitalOut _rst;
    DigitalOut _cs;    
    DigitalOut _rs;    
    void bitblit(int x, int y, int width, int height, const char* bitstream);
    void fill(int x, int y, int width, int height, int colour);
    void blit(int x, int y, int width, int height, const int* colour);
    /* Function: cls
     *  Clear the screen
     */
    void cls();
    /* Functions returning the current max width, max height, max columns, max rows, orientation
    *  and tablength as an integer
    */
    int width();
    int height();
    int columns();
    int rows();
    int orientation();
    int tablength();
    /* Functions returning the current foreground or background colour as a three-byte RGB code */
    int foreground();
    int background();
    void putp(int v);
    void window(int x, int y, int width, int height);
    void pixel(int x, int y, int colour);
    enum {_physical_width=160};
    enum {_physical_height=128};
    int _row, _column, _rows, _columns, _tablength, _foreground, _background, _width, _height, _rotation, _writing_pixels;
};

}

#endif
