#include <string.h>
#include "mbed.h"
#include "OLEDSeps525f.h"
OLEDSeps525f lcd(p5, p6, p7, p8, p9, p10);

int main() {
    //Test background and clear screen
    lcd.background(0x0000FF);
    lcd.cls();
    //Test colour and fill
    lcd.fill(0, 50, lcd.width(), 10, 0x00FF00);
    lcd.fill(50, 0, 10, lcd.height(), 0xFF0000);
    //Test pixel writing
    for(int i=0; i<lcd.width(); i++) {
        lcd.pixel(i, 80 + sin((float)i / 5.0)*10, 0x000000);
    }
    lcd.locate(0,1);
    //Test text and newline
    lcd.printf("OLED\ndriver\n");
    //Test tab
    lcd.printf("\ttab\t2\t3\t4");
    lcd.locate(0,10);    
    //Test control codes
    lcd.printf("\t*\v*\v\b\b*\r*");
    //Test orientation
    lcd.locate(lcd.columns()/2-(strlen("Top  ")/2),1);
    lcd.printf("Top %u",lcd.orientation());
    lcd.orientation(1);
    lcd.locate(lcd.columns()/2-(strlen("Right  ")/2),1);
    lcd.printf("Right %u",lcd.orientation());
    lcd.orientation(2);
    lcd.locate(lcd.columns()/2-(strlen("Bottom  ")/2),1);
    lcd.printf("Bottom %u",lcd.orientation());
    lcd.orientation(3);
    lcd.locate(lcd.columns()/2-(strlen("Left  ")/2),1);
    lcd.printf("Left %u",lcd.orientation());

}