
#define SAMPLE_RATE    150000

#include "mbed.h"
#include "adc.h"

DigitalOut int_led(LED1);

//Initialise ADC to maximum SAMPLE_RATE and cclk divide set to 1
ADC adc(SAMPLE_RATE, 1);

//Toggle LED on interrupt
void led_toggle(int chan, uint32_t value) {
    int_led = !int_led;
}

//Report ADC value on interrupt
void print_value(int chan, uint32_t value) {
    printf("ADC interrupt on pin %u, value=%04u.\n", 
        adc.channel_to_pin_number(chan), (value >> 4) & 0xFFF);
}


int main() {
    int i;
    
    printf("Requested max sample rate is %u, actual max sample rate is %u.\n",
        SAMPLE_RATE, adc.actual_sample_rate());
    while (1) {
    
        //Set up ADC on pin 20
        adc.setup(p20,1);
        //Set up ADC on pin 19
        adc.setup(p19,1);
        wait(1);
        
        //Measure pin 20
        adc.select(p20);
        //Start ADC conversion
        adc.start();
        //Wait for it to complete
        while(!adc.done(p20));
        printf("Measured value on pin 20 is %04u.\n", adc.read(p20));
        wait(1);

        //Measure pin 19
        adc.select(p19);
        //Start ADC conversion
        adc.start();
        //Wait for it to complete
        while(!adc.done(p19));
        printf("Measured value on pin 19 is %04u.\n", adc.read(p19));
        wait(1);

    
        //Append an interrupt handler that prints the channel and value
        adc.append(print_value);
        //Measure pin 20
        adc.select(p20);
        //Enable the interrupt
        adc.interrupt_state(p20,1);
        //Start ADC conversion
        adc.start();
        //Wait for it to complete
        while(!adc.done(p20));
        wait(1);
    
        //Unset pin 20
        adc.setup(p20,0);
    
        //Togle LED on each converstion.
        //Should be 12.5KHz on LED for all 6 pins.
        //Sample rate=150KHz / 6 channels / 2
        adc.append(led_toggle);
    
        //Prepare for burst mode on all ADC pins
        adc.startmode(0,0);
        adc.burst(1);
        adc.setup(p20,1);
        adc.setup(p19,1);
        adc.setup(p18,1);
        adc.setup(p17,1);
        adc.setup(p16,1);
        adc.setup(p15,1);
        //For burst mode, only one interrupt is required
        //which can be on any enabled pin. We have enabled all
        //of them here.
        adc.interrupt_state(p15,1);
        printf("Burst mode, printing once per second...\n");
        for (i=0; i<5; i++)
        {
            printf("%04u %04u %04u %04u %04u %04u\n", 
                adc.read(p20),
                adc.read(p19),
                adc.read(p18),
                adc.read(p17),
                adc.read(p16),
                adc.read(p15));
            wait(1);
        }
        adc.burst(0);
        adc.setup(p20,0);
        adc.setup(p19,0);
        adc.setup(p18,0);
        adc.setup(p17,0);
        adc.setup(p16,0);
        adc.setup(p15,0);
        adc.interrupt_state(p20,0);
        adc.interrupt_state(p19,0);
        adc.interrupt_state(p18,0);
        adc.interrupt_state(p17,0);
        adc.interrupt_state(p16,0);
        adc.interrupt_state(p15,0);
        
        printf("\n");
    }
}
