
#define SAMPLE_RATE    150000

#include "mbed.h"
#include "adc.h"

//Initialise ADC to maximum SAMPLE_RATE and cclk divide set to 1
ADC adc(SAMPLE_RATE, 1);

uint32_t adc_max, adc_av, adc_min;
int snap = 0;

void min_max_av(int chan, uint32_t value) {
    static uint64_t adc_tot, counter = 0;
    static uint32_t adc_max_tmp, adc_min_tmp;
    
    
    int adc_value;
    
    adc_value = adc.read(p20);
    //Update min, max and average records and totals
    if (adc_value > adc_max_tmp) adc_max_tmp = adc_value;
    if (adc_value < adc_min_tmp) adc_min_tmp = adc_value;
    adc_tot += adc_value;
    counter++;
    //If snapshot requested then sample data and reset average
    if (snap) { 
        adc_max = adc_max_tmp;
        adc_av = (int)(adc_tot / counter);
        adc_min = adc_min_tmp;
        adc_max_tmp = 0;
        adc_min_tmp = 0xFFFF;
        adc_tot = 0;
    }
    if (snap) counter = 0;
    snap = 0;
}

//Show a bargraph of ADC value
void bar(int value) {
    int i, j;
    
    j = (value * 50) / 4096;
    
    if (j > 50) j = 50;
    if (j < 0) j = 0;
    
    for (i = 0; i < j; i++)
        printf("=");
     printf("\n");
}

int main() {
    
    printf("\nRequested max sample rate is %u, actual max sample rate is %u.\n",
        SAMPLE_RATE, adc.actual_sample_rate());
    adc.append(min_max_av);

    //Prepare for burst mode on all ADC pins
    adc.startmode(0,0);
    adc.burst(1);
    adc.setup(p20,1);
    adc.interrupt_state(p20,1);
    
    printf("Burst mode, printing once per second...\n");
    while (1) {
        snap = 1;
        wait(0.5);
            printf ("Min :");
            bar(adc_min);
            printf ("Av  :");
            bar(adc_av);
            printf ("Max :");
            bar(adc_max);
            printf("\n");
        printf("......................................................\n");    
        wait(0.5);
    }
}
