#include "mbed.h"
#include "LCD_DISCO_F746NG.h"

#include <sstream>
#include <queue>

/*
 *  TFTSTREAM DEMO:
 
#include "mbed.h"
#include "TftStream.h"


int main()
{
    TftStream tft_out;
    LCD_DISCO_F746NG& lcd = tft_out.getLcd();

    tft_out << "TftStream_demo for DISCOVERY STM32F746NG\n\n";
    wait(1);

    while(1) {
        wait(0.5);
        for (int i = 0; i < 30; ++i) {
            tft_out << i << " slow output\n";
            wait(0.1);
        }
        wait(0.1);
        
        for (int i = 0; i < 30; ++i) {
            tft_out << i << " fast output\n";
            wait(0.01);
        }
        wait(0.1);
        
        for (int i = 0; i < 30; ++i) {
            tft_out << i << " very fast output\n";
        }
        wait(0.1);
            
        tft_out << "\n\nsome\n\nnewlines\n";
        wait(0.5);
        tft_out << "this is a looooooooooooooooooooooooooooooooooooooooong text\n";
        wait(0.5);

        lcd.SetTextColor(LCD_COLOR_YELLOW);
        tft_out << "HAVE FUN !!!\n";
        wait(1);
        
        tft_out.clear();
        tft_out.resetFont();
        wait(2);
    }
}
 */


//Serial pc(SERIAL_TX, SERIAL_RX); // DEBUG

class TftStream
{
public:
    // init empty screen with default font
    TftStream()
    :
    lineLengthMax(28),
    lineCntMax(11)
    {
        _lcd.Clear(LCD_COLOR_BLUE); 
        resetFont();
    }

    // use this like std::cout: TftStream stream; stream << "i:" << i << "\n";
    // the screen is only updated if there is a newline '\n' at the end
    template<typename T>
    TftStream& operator <<(const T& arg) 
    {
        _streamBuffer << arg;
        
        const bool newLineAtEnd = *(_streamBuffer.str().end() - 1) == '\n';
        
        if (newLineAtEnd == false)
        {
            return *this;
        }

        addNewLinesFromBuffer();

        while (_linesNew.size() > 1)
        {
            newLineToSrceenLines();
            drawLines();
        }
        
        if (newLineAtEnd)
        {
            newLineToSrceenLines();
            drawLines();
        }
            
        return *this;
    }
    
    // get the underlying screen object for direct manipulation
    LCD_DISCO_F746NG& getLcd()
    {
        return _lcd;
    }
    
    // clear the screen
    void clear()
    {
        _lcd.Clear(LCD_COLOR_BLUE);       
        _linesOnScreen.clear();
    }
    
    // reset to default font
    void resetFont()
    {
        _lcd.SetBackColor(LCD_COLOR_BLUE);
        _lcd.SetTextColor(LCD_COLOR_WHITE);
    }
    
private:
    void addNewLinesFromBuffer()
    {
        std::string line;
        std::istringstream lineStream(_streamBuffer.str());
        _streamBuffer.str("");
        
        while (std::getline(lineStream, line, '\n')) {
            if (line.empty())
            {
                line = std::string(lineLengthMax, ' ');
            }
            
            for (unsigned i = 0; i < line.length(); i += lineLengthMax ) 
            {
                std::string lineTrimmed = line.substr(i, lineLengthMax );
                lineTrimmed = lineTrimmed += std::string(lineLengthMax - lineTrimmed.length(), ' ');
                _linesNew.push(lineTrimmed);
                //pc.printf("  line tr: '%s'\n", lineTrimmed.c_str());
            }
        }
    }
    
    
    void drawLines()
    {
        int lineNb = 0;
        for (std::deque<std::string>::iterator lineIt = _linesOnScreen.begin(); lineIt != _linesOnScreen.end(); ++lineIt)
        {
            _lcd.DisplayStringAtLine(lineNb, (uint8_t *)(lineIt->c_str()));
            ++lineNb;
        }         
    }
    
    
    void newLineToSrceenLines()
    {
        _linesOnScreen.push_back(_linesNew.front());
        _linesNew.pop();
        
        if(_linesOnScreen.size() > lineCntMax)
        {
            _linesOnScreen.pop_front();
        }       
    }
    
    
    const int lineLengthMax;
    const int lineCntMax;
      
    std::ostringstream      _streamBuffer;
    std::queue<std::string> _linesNew;
    std::deque<std::string> _linesOnScreen;
    LCD_DISCO_F746NG        _lcd;    
};