#ifndef SONAR_SENSOR_SONAR_H
#define SONAR_SENSOR_SONAR_H

#include "mbed.h"
#include "hcsr04.h"

Serial pc(USBTX, USBRX); // tx, rx
HCSR04  frontRight(p26, p9);
HCSR04  frontLeft(p25, p8);
HCSR04  rearRight(p24, p7);
HCSR04  rearLeft(p23, p6);

const unsigned int waitDuration = 500; //ms
const unsigned int MaxDistance = 20;


unsigned int sensorDistance[4] = {9999, 9999 ,9999, 9999};

void getDistance(){
    for(int i = 0; i<4; ++i)
        sensorDistance[i] = 9999;

    frontRight.start();
    frontLeft.start();
    rearRight.start();
    rearLeft.start();

    wait_ms(waitDuration);

    sensorDistance[0] = frontRight.get_dist_cm();
    sensorDistance[1] = frontLeft.get_dist_cm();
    sensorDistance[2] = rearRight.get_dist_cm();
    sensorDistance[3] = rearLeft.get_dist_cm();
}

void printDistance(){
    for(int i = 0; i<4; ++i)
        pc.printf("Distance%d: %dcm\r\n", i+1 ,sensorDistance[i]);
}

void printDistance2(){
    for(int i = 0; i<2; ++i)
        pc.printf("Distance%d: %dcm\r\n", i+1 ,sensorDistance[i]);
}

//return true if obstacle is to close and car needs to dodge
bool avoidObstacle(const unsigned int &distance){
    return distance>=MaxDistance;
}


#endif //SONAR_SENSOR_SONAR_H