#ifndef BUZZER_BUZZER_H
#define BUZZER_BUZZER_H

#include "mbed.h"

DigitalOut Buzzer(p13);

const float bREVERSE = 0.4, bTERMINATE = 1, bSTUCK = 0.4, bFLIPPED = 0.15;

void buzzerReverse(){
    Buzzer = 1;
    wait(bREVERSE);
    Buzzer= 0;
    wait(bREVERSE);
}

void buzzerTerminate(){
    Buzzer = 1;
    wait(bTERMINATE);
    Buzzer= 0;
    wait(bTERMINATE);
}

void buzzerStuck(){
    Buzzer = 1;
    wait(bSTUCK);
    Buzzer= 0;
    wait(bSTUCK);
}

void buzzerFlipped(){
    Buzzer = 1;
    wait(bFLIPPED);
    Buzzer= 0;
    wait(bFLIPPED);
}

//used for reverse when getting to close to an object
void buzz(const float &speed){
    Buzzer = 1;
    wait(speed);
    Buzzer= 0;
    wait(speed);
}

#endif //BUZZER_BUZZER_H
