/*
Projet du drone instrumenté compportant un GPS et un capteur de température/humidité, un gyroscope et un module Bluetooth

*/
#include <iostream>
#include "mbed.h"
#include "BufferedSerial.h"
#include "Dht11.h"
#include "LSM6DS33.h"

Serial BT(PA_9, PA_10, 9600);
//Serial GPS(PA_2, PA_3, 9600);
I2C i2c(PB_7,PB_6);

Dht11 sensor(PB_1);
LSM6DS33 acc = LSM6DS33(PB_7, PB_6);

int main()
{
    uint8_t tab[100];
    char latitude[9],longitude[10];    //latitude == l / longitude == L
    int Te, Hu;
    char buff[50], TH[6];
    char tab2[5];   //tableau vérification id trame GPS
    int i=0;
    float axx,ayy,azz,gxx,gyy,gzz;  //variables gyroscope

    acc.begin(LSM6DS33::G_SCALE_245DPS, LSM6DS33::A_SCALE_2G, LSM6DS33::G_ODR_1660, LSM6DS33::A_ODR_6660);  //Init gyroscope

    //BT.printf("Hello World\n\r");

    while(1) {

        if( BT.getc() == '$') {        //condition attente début de trame
            for(i = 0; (i< 5) ; i++) {  //stocke l'ID de la trame reçue
                tab2[i] = BT.getc();
            }
            if( (tab2[0]=='G') && (tab2[1]=='P') && (tab2[2]=='R') && (tab2[3]=='M') && (tab2[4]=='C') ) {  //Compare si c'est la trame attendue
                for(i = 1; (i< 40) ; i++) {     //stockage de la trame dans un tableau temp
                    tab[i] = BT.getc();
                }
                for(i = 0; (i< 9) ; i++) {             //Extraction de la latitude latitude dans un tableau
                    latitude[i] = tab[i + 15];
                }
                for(i = 0; (i< 10) ; i++) {             //Extraction de la latitude longitude dans un tableau
                    longitude[i] = tab[i + 27];
                }
            }
            //récupération données température et humidité
            sensor.read();
            Te = sensor.getCelsius();
            Hu = sensor.getHumidity();

            //récupération données gyroscope et accéléromètre
            acc.readAll();

            acc.readAccel();
            axx = acc.ax;   //gyro en x
            ayy = acc.ay;   //gyro en y
            azz = acc.az;   //gyro en z

            acc.readGyro();
            gxx = acc.gx;   //acceleration en x
            gyy = acc.gy;   //acceleration en y
            gzz = acc.gz;   //acceleration en z

            //Concatenation des données en un string
            sprintf(TH,"T%dH%d\n",Te,Hu);
            strcat(buff,"l");
            strcat(buff,latitude);
            strcat(buff,"L");
            strcat(buff,longitude);
            strcat(buff,TH);
            
            BT.puts(buff);  //Envoi du string en Bluetooth

            for(i = 0; i < 50; i++) {
                buff[i] = '\0';
            }
            wait(5);
        }
    }
}